% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{cat0}
\alias{cat0}
\title{Concatenate and Print with No Separator}
\usage{
cat0(
  ...,
  n.before = 1L,
  n.after = 1L,
  file = "",
  fill = FALSE,
  labels = NULL,
  append = FALSE
)
}
\arguments{
\item{...}{one or more R objects. See details of \code{cat} for types of objects
allowed.}

\item{n.before}{integer vector of length 1 specifying how many line breaks to have
before printing the concatenated R objects.}

\item{n.after}{integer vector of length 1 specifying how many line breaks to have
after printing the concatenated R objects.}

\item{file}{A connection or a character string naming the file to print to.
If "" (default), \code{cat0} prints to the standard output connection - the
console - unless redirected by \code{sink}.}

\item{fill}{A logical or (positive) numeric vector of length 1 controlling how
the output is broken into successive lines. If FALSE (default), new line breaks are
only created explicity by \code{"\\n"} bring called. If TRUE, the output is broken into
lines with print width equal to the option "width" (\code{options()[["width"]]}).
If a (positive) number, then the output is broken after width of that length.}

\item{labels}{A character vector of labels for the lines printed. Ignored if
\code{fill} = FALSE.}

\item{append}{A logical vector of length 1. Only used if the argument \code{file}
is the name of a file (and not a connection). If TRUE, output will be appended
to the existing file. If FALSE, output will overwrite the contents of the file.}
}
\value{
nothing as the function only prints and does not return an R object.
}
\description{
\code{cat0} concatenates and prints objects without any separator. \code{cat0}
is to \code{cat} as \code{paste0} is to \code{paste}. It also allows you to
specify line breaks before (\code{n.before}) and after (\code{n.after}) the
the printing of the concatenated R objects. \code{cat0} function can be useful
in conjunction with \code{sink} for quick and dirty exporting of results.
}
\examples{
cat0(names(attitude))
cat0("MODEL COEFFICIENTS:", coef(lm(rating ~ critical + advance, data = attitude)),
   n.before = 0, n.after = 2)
}
