% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_projected.R
\name{geo_select_aeq}
\alias{geo_select_aeq}
\title{Select a custom projected CRS for the area of interest}
\usage{
geo_select_aeq(shp)
}
\arguments{
\item{shp}{A spatial object with a geographic (WGS84) coordinate system}
}
\description{
This function takes a spatial object with a geographic (WGS84)
CRS and returns a custom projected CRS focussed on the centroid of the object.
This function is especially useful for using units of metres in all directions
for data collected anywhere in the world.
}
\details{
The function is based on this stackexchange answer:
\url{https://gis.stackexchange.com/questions/121489}
}
\examples{
shp <- zones_sf
geo_select_aeq(shp)
}
\seealso{
Other geo: 
\code{\link{bbox_scale}()},
\code{\link{bind_sf}()},
\code{\link{geo_bb}()},
\code{\link{geo_bb_matrix}()},
\code{\link{geo_buffer}()},
\code{\link{geo_length}()},
\code{\link{geo_projected}()},
\code{\link{quadrant}()}
}
\concept{geo}
