% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyclestreets.R
\name{nearest_cyclestreets}
\alias{nearest_cyclestreets}
\title{Generate nearest point on the route network of a point using the CycleStreets.net}
\usage{
nearest_cyclestreets(shp = NULL, lat, lng, pat = api_pat("cyclestreet"))
}
\arguments{
\item{shp}{A spatial object}

\item{lat}{Numeric vector containing latitude coordinate for each coordinate
to map. Also accepts dataframe with latitude in the first column and
longitude in the second column.}

\item{lng}{Numeric vector containing longitude coordinate for each
coordinate to map.}

\item{pat}{The API key used. By default this is set to NULL and
this is usually aquired automatically through a helper, api_pat().}
}
\description{
Generate nearest point on the route network of a point using the CycleStreets.net
}
\section{Details}{

Retrieve coordinates of the node(s) on the network mapped from coordinates
passed to functions.

Note: there is now a dedicated cyclestreets package:
https://github.com/Robinlovelace/cyclestreets
}

\examples{
\dontrun{
nearest_cyclestreets(53, 0.02, pat = Sys.getenv("CYCLESTREETS"))
nearest_cyclestreets(cents[1, ], pat = Sys.getenv("CYCLESTREETS"))
nearest_cyclestreets(cents_sf[1, ], pat = Sys.getenv("CYCLESTREETS"))
}
}
