% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_parlperiod_presidency.R
\name{get_parlperiod_presidency}
\alias{get_parlperiod_presidency}
\title{Get list of presidency in a given parliamentary period}
\usage{
get_parlperiod_presidency(periodid = NA, good_manners = 0)
}
\arguments{
\item{periodid}{Character string indicating the id of the parliamentary period to retrieve.}

\item{good_manners}{Integer. Seconds delay between calls when making multiple calls to the same function}
}
\value{
A data.frame with the following variables:\tabular{ll}{
    \tab  \cr
   \strong{response_date} \tab Date of data retrieval \cr
   \strong{version} \tab Data version from the API \cr
   \strong{last_name} \tab Last name of presidency member \cr
   \strong{first_name} \tab First name of presidency member \cr
   \strong{from_date} \tab Presidency member from date \cr
   \strong{party_id} \tab Party affiliation of presidency member \cr
   \strong{person_id} \tab Id of the presidency member \cr
   \strong{to_date} \tab Presidency member to date \cr
   \strong{position} \tab Presidency position \cr
}
}
\description{
A function for retrieving the presidency for a given parliamentary period from the parliament API.
}
\examples{
\dontrun{
 
# Request one MP by id
get_parlperiod_presidency("2005-2009")

}

}
\seealso{
\link{get_mp} \link{get_mp_bio}
}
