% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structurednessindices.R
\name{c_linearity}
\alias{c_linearity}
\title{c-linearity
calculates c-linearity as the aggregated multiple correlation of all columns of the configuration.}
\usage{
c_linearity(confs, aggr = max)
}
\arguments{
\item{confs}{a numeric matrix or data frame}

\item{aggr}{the aggregation function for configurations of more than two dimensions. Defaults to max.}
}
\value{
a numeric value; linearity (aggregated multiple correlation of all columns of the configuration)
}
\description{
c-linearity
calculates c-linearity as the aggregated multiple correlation of all columns of the configuration.
}
\examples{
x<-1:10
y<-2+3*x+rnorm(10)
z<- sin(y-x)
confs<-cbind(z,y,x)
c_linearity(confs)
}
