% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stops.R
\name{stop_sstress}
\alias{stop_sstress}
\title{STOPS version of sstress}
\usage{
stop_sstress(
  dis,
  theta = 1,
  weightmat = NULL,
  init = NULL,
  ndim = 2,
  itmax = 1e+05,
  ...,
  stressweight = 1,
  structures = c("cclusteredness", "clinearity", "cdependence", "cmanifoldness",
    "cassociation", "cnonmonotonicity", "cfunctionality", "ccomplexity", "cfaithfulness",
    "cregularity", "chierarchy", "cconvexity", "cstriatedness", "coutlying",
    "cskinniness", "csparsity", "cstringiness", "cclumpiness", "cinequality"),
  strucweight = rep(1/length(structures), length(structures)),
  strucpars,
  verbose = 0,
  type = c("additive", "multiplicative")
)
}
\arguments{
\item{dis}{numeric matrix or dist object of a matrix of proximities}

\item{theta}{the theta vector of powers; this must be a scalar of the lambda transformation for the observed proximities. Defaults to 1. Note that the lambda here works as a multiplicator of 2 (as sstress has f(delta^2)).}

\item{weightmat}{(optional) a matrix of nonnegative weights}

\item{init}{(optional) initial configuration}

\item{ndim}{the number of dimensions of the target space}

\item{itmax}{number of iterations}

\item{...}{additional arguments to be passed to the fitting procedure}

\item{stressweight}{weight to be used for the fit measure; defaults to 1}

\item{structures}{which structuredness indices to be included in the loss}

\item{strucweight}{weight to be used for the structuredness indices; ; defaults to 1/#number of structures}

\item{strucpars}{the parameters for the structuredness indices}

\item{verbose}{numeric value hat prints information on the fitting process; >2 is extremely verbose}

\item{type}{How to construct the target function for the multi objective optimization? Either 'additive' (default) or 'multiplicative'}
}
\value{
A list with the components
   \itemize{
        \item{stress:} the stress
        \item{stress.m:} default normalized stress
        \item{stoploss:} the weighted loss value
        \item{indices:} the values of the structuredness indices
        \item{parameters:} the parameters used for fitting 
        \item{fit:} the returned object of the fitting procedure
         \item{stopobj:} the stopobj object
}
}
\description{
Free parameter is lambda for the observed proximities. Fitted distances are transformed with power 2, weights have exponent of 1. Note that the lambda here works as a multiplicator of 2 (as sstress has f(delta^2)).
}
\keyword{multivariate}
