% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stops.R
\name{stop_smacofSym}
\alias{stop_smacofSym}
\title{STOPS version of smacofSym models}
\usage{
stop_smacofSym(
  dis,
  theta = 1,
  ndim = 2,
  weightmat = NULL,
  init = NULL,
  itmax = 1000,
  ...,
  structures = c("cclusteredness", "clinearity", "cdependence", "cmanifoldness",
    "cassociation", "cnonmonotonicity", "cfunctionality", "ccomplexity", "cfaithfulness",
    "chierarchy", "cconvexity", "cstriatedness", "coutlying", "cskinniness", "csparsity",
    "cstringiness", "cclumpiness", "cinequality"),
  stressweight = 1,
  strucweight = rep(1/length(structures), length(structures)),
  strucpars,
  verbose = 0,
  type = c("additive", "multiplicative")
)
}
\arguments{
\item{dis}{numeric matrix or dist object of a matrix of proximities}

\item{theta}{the theta vector; must be a scalar for the lambda (proximity) transformation. Defaults to 1.}

\item{ndim}{number of dimensions of the target space}

\item{weightmat}{(optional) a matrix of nonnegative weights}

\item{init}{(optional) initial configuration}

\item{itmax}{number of iterations}

\item{...}{additional arguments to be passed to the fitting}

\item{structures}{which structuredness indices to be included in the loss}

\item{stressweight}{weight to be used for the fit measure; defaults to 1}

\item{strucweight}{weight to be used for the structuredness indices; ; defaults to 1/#number of structures}

\item{strucpars}{the parameters for the structuredness indices}

\item{verbose}{numeric value hat prints information on the fitting process; >2 is extremely verbose}

\item{type}{How to construct the target function for the multi objective optimization? Either 'additive' (default) or 'multiplicative'}
}
\value{
A list with the components
   \itemize{
        \item{stress:} the stress-1 (sqrt(stress.m))
        \item{stress.m:} default normalized stress (used for STOPS)
        \item{stoploss:} the weighted loss value
        \item{indices:} the values of the structuredness indices
        \item{parameters:} the parameters used for fitting 
        \item{fit:} the returned object of the fitting procedure
        \item{stopobj:} the stops object
}
}
\description{
The free parameter is lambda for power transformations the observed proximities. The fitted distances power is internally fixed to 1 and the power for the weights is 1.
}
\keyword{multivariate}
