% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stops.R
\name{plot.stops}
\alias{plot.stops}
\title{S3 plot method for stops objects}
\usage{
\method{plot}{stops}(x, plot.type = c("confplot"), main, asp = NA, ...)
}
\arguments{
\item{x}{an object of class stops}

\item{plot.type}{String indicating which type of plot to be produced: "confplot", "resplot", "Shepard", "stressplot", "bubbleplot" (see details)}

\item{main}{the main title of the plot}

\item{asp}{aspect ratio of x/y axis; defaults to NA; setting to 1 will lead to an accurate represenation of the fitted distances.}

\item{...}{Further plot arguments passed: see 'plot.smacof' and 'plot' for detailed information.

Details:
\itemize{
\item Configuration plot (plot.type = "confplot"): Plots the MDS configurations.
\item Residual plot (plot.type = "resplot"): Plots the dissimilarities against the fitted distances.
\item Linearized Shepard diagram (plot.type = "Shepard"): Diagram with the transformed observed dissimilarities against the transformed fitted distance as well as loess smooth and a least squares line.
\item Stress decomposition plot (plot.type = "stressplot", only for SMACOF objects in $fit): Plots the stress contribution in of each observation. Note that it rescales the stress-per-point (SPP) from the corresponding smacof function to percentages (sum is 100). The higher the contribution, the worse the fit.
\item Bubble plot (plot.type = "bubbleplot", only available for SMACOF objects $fit): Combines the configuration plot with the point stress contribution. The larger the bubbles, the better the fit.
}}
}
\value{
no return value, just plots
}
\description{
S3 plot method for stops objects
}
