% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stp.R
\name{stp}
\alias{stp}
\title{Create \code{stp} and \code{stlp} objects for point patterns storage}
\usage{
stp(df, L)
}
\arguments{
\item{df}{A matrix with three columns, containing to two space and the
temporal coordinates}

\item{L}{Optional. The linear network of class \code{linnet}.
If provided, the function returns a \code{stlp} object.}
}
\value{
An \code{stp} or \code{stlpp} object, depending on whether or not an object of class
linnet is provided for the \code{L} argument.
}
\description{
This function creates a \code{stp} object as a dataframe with three columns:
\code{x}, \code{y}, and \code{t}.
If also the linear network \code{L}, of class linnet, is provided, a \code{stlp}
object is created instead.
}
\examples{

set.seed(2)
df <- data.frame(runif(100), runif(100), runif(100))

stp1 <- stp(df)

set.seed(2)                       
df_net <- data.frame(runif(100, 0, 0.85), runif(100, 0, 0.85), runif(100))

stlp1 <- stp(df_net, L = chicagonet)


}
\seealso{
\link{summary.stp}, \link{print.stp}, \link{plot.stp}

\link{stppm},
\link{print.stp}, \link{summary.stp}, \link{plot.stp},
\link{print.stlp},
\link{summary.stlp}, \link{plot.stlp}
}
\author{
Nicoletta D'Angelo
}
