% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochvol-cpp-doc.R
\name{update_fast_sv}
\alias{update_fast_sv}
\title{Single MCMC Update Using Fast SV}
\usage{
update_fast_sv(log_data2, mu, phi, sigma, h0, h, r, prior_spec, expert)
}
\arguments{
\item{log_data2}{log(data^2), where data is the vector of de-meaned observations}

\item{mu}{parameter mu. Level of the latent process h. Updated in place}

\item{phi}{parameter phi, persistence of the latent process h. Updated in place}

\item{sigma}{parameter sigma, volatility of the latent process h, also called volvol. Updated in place}

\item{h0}{parameter h0, the initial value of the latent process h. Updated in place}

\item{h}{the vector of the latent process. Updated in place}

\item{r}{the vector of the mixture indicators. Updated in place}

\item{prior_spec}{prior specification object. See type_definitions.h}

\item{expert}{expert settings for this function. See type_definitions.h}
}
\description{
Samples the mixture indicators, the latent variables, and the model independent
parameters mu, phi, and sigma. The input is the logarithm of the squared de-meaned
observations. An approximate SV model is estimated instead of the exact SV model
by the use of auxiliary mixture sampling.
Depending on the prior specification, mu might not be updated.
Depending on the expert settings, the function might follow the ancillarity-sufficiency
interweaving strategy (ASIS, Yu and Meng, 2011) for sampling mu, phi, and sigma.
Furthermore, the user can turn off the sampling of the parameters, the latents, or the
mixture indicators in the expert settings.
}
\seealso{
Other stochvol_cpp: 
\code{\link{update_general_sv}()},
\code{\link{update_regressors}()},
\code{\link{update_t_error}()}
}
\concept{stochvol_cpp}
\keyword{update}
