% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpoistpp.R
\name{rpoistpp}
\alias{rpoistpp}
\title{Simulating one-dimensional Poisson point patterns}
\usage{
rpoistpp(lambda,a,b,check=FALSE,lmax=NULL,nsim=1)
}
\arguments{
\item{lambda}{intensity of the point process. it can be either a number, a function of location and time, or an object of class \code{tppint}}

\item{a}{lower bound of time period}

\item{b}{upper bound of time period}

\item{check}{logical value indicating whether to check that all the (x,y) points lie inside the specified time period.}

\item{lmax}{upper bound for the values of \code{labmda}. this is optional}

\item{nsim}{number of simulated patterns to generate}
}
\value{
an object of class \code{\link{tpp}} if nsim=1, otherwise a list of objects of class \code{\link{tpp}}.
}
\description{
This function simulates realisations of an one-dimensional Poisson point process.
}
\details{
This function generates realisations of a temporal poisson point process based on a given intensity function lambda and lower/upper bounds a and b.
}
\examples{
 
f <- function(t){0.1*exp(t)}
X <- rpoistpp(f,a=1,b=10)

}
\references{
Moradi, M., & Mateu, J. (2020). First-and second-order characteristics of spatio-temporal point processes on linear networks. Journal of Computational and Graphical Statistics, 29(3), 432-443.
}
\seealso{
\code{\link{rpoistlpp}}
}
\author{
Mehdi Moradi <m2.moradi@yahoo.com>
}
