% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/at.R
\name{center_at}
\alias{center_at}
\alias{diff_at}
\alias{group_mean_center_at}
\alias{lag_at}
\alias{log_at}
\alias{mean_at}
\alias{r1sd_at}
\alias{r2sd_at}
\title{Scoped Helper Verbs}
\usage{
center_at(data, x, prefix = "c", na = TRUE)

diff_at(data, x, o = 1, prefix = "d")

group_mean_center_at(data, x, mean_prefix = "mean", prefix = "b", na = TRUE)

lag_at(data, x, prefix = "l", o = 1)

log_at(data, x, prefix = "ln", plus_1 = FALSE)

mean_at(data, x, prefix = "mean", na = TRUE)

r1sd_at(data, x, prefix = "s", na = TRUE)

r2sd_at(data, x, prefix = "z", na = TRUE)
}
\arguments{
\item{data}{a data frame}

\item{x}{a vector, likely in your data frame}

\item{prefix}{Allows the user to rename the prefix of the new variables.  Each
function has defaults (see details section).}

\item{na}{a logical about whether missing values should be ignored in the
creation of means and re-scaled variables. Defaults to TRUE (i.e. pass
over/remove missing observations). Not applicable to \code{diff_at},
\code{lag_at}, and \code{log_at}.}

\item{o}{The order of lags for calculating differences or lags in
\code{diff_at} or \code{lag_at}. Applicable only to these functions.}

\item{mean_prefix}{Applicable only to \code{group_mean_center_at}. Specifies
the prefix of the (assumed) total population mean variables. Default is "mean",
though the user can change this as they see fit.}

\item{plus_1}{Applicable only to \code{log_at}. If TRUE, adds 1 to the
variables prior to log transformation. If FALSE, performs logarithmic
transformation on variables no matter whether 0 occurs (i.e. 0s will
come back as -Inf). Defaults to FALSE.}
}
\value{
The function returns a set of new vectors in a data frame after
performing relevant functions. The new vectors have distinct prefixes
corresponding with the action performed on them.
}
\description{
Scoped helper verbs included in this R Documentation file
allow for targeted commands on specified columns. They also rename
the ensuing output to conform to my preferred style. The commands here
are multiple and explained in the details section below.
}
\details{
\code{center_at} is a wrapper for \code{mutate_at} and \code{rename_at} from
\pkg{dplyr}. It takes supplied vectors and effectively centers them from the
mean. It then renames these new variables to have a prefix of \code{c_}. The
default prefix ("c") can be changed by way of an argument in the function.

\code{diff_at} is a wrapper for \code{mutate_at} and \code{rename_at} from
\pkg{dplyr}. It takes supplied vectors and creates differences from the
previous value recorded above it. It then renames these new variables to have
a prefix of \code{d_} (in the case of a first difference), or something like
\code{d2_} in the case of second differences, or \code{d3_} in the case of
third differences (and so on). The exact prefix depends on the \code{o}
argument, which communicates the order of lags you want. It defaults to 1. The
default prefix ("d") can be changed by way of an argument in the function,
though the naming convention will omit a numerical prefix for first
differences.

\code{group_mean_center_at} is a wrapper for \code{mutate} and \code{across}
in \pkg{dplyr}. It takes supplied vectors and centers an (assumed) group mean
of the variables from an (assumed) total population mean of the variables
provided to it. It then returns the new variables with a prefix, whose default
is \code{b_}. This prefix communicates, if you will, a kind of "between"
variable in the panel model context, in juxtaposition to "within" variables
in the panel model context.

\code{lag_at} is a wrapper for \code{mutate} and \code{across} from
\pkg{dplyr}. It takes supplied vector(s) and creates lag variables from them.
These new variables have a prefix of \code{l[o]_} where \code{o} corresponds
to the order of the lag (specified by an argument in the function, which
defaults to 1). This default prefix ("l") can be changed by way of an
another argument in the function.

\code{log_at} is a wrapper for \code{mutate_at} and \code{rename_at} from
\pkg{dplyr}. It takes supplied vectors and creates a variable that takes
a natural logarithmic transformation of them. It then renames these new
variables to have a prefix of \code{ln_}. This default prefix ("ln") can be
changed by way of an argument in the function. Users can optionally specify
that they want to add 1 to the vector before taking its natural logarithm,
which is a popular thing to do when positive reals have naturally occurring
zeroes.

\code{mean_at} is a wrapper for \code{mutate_at} and \code{rename_at} from
\pkg{dplyr}. It takes supplied vectors and creates a variable communicating
the mean of the variable. It then renames these new variables to have a
prefix of \code{mean_}. This default prefix ("mean") can be changed by way of
an argument in the function.

\code{r1sd_at} is a wrapper for \code{mutate_at} and \code{rename_at} from
\pkg{dplyr}. It both rescales the supplied vectors to new vectors and renames
the vectors to each have a prefix of \code{s_}. Note the rescaling here is
just by one standard deviation and not two. The default prefix ("s") can be
changed by way of an argument in the function.

\code{r2sd_at} is a wrapper for \code{mutate_at} and \code{rename_at} from
\pkg{dplyr}. It both rescales the supplied vectors to new vectors and renames
the vectors to each have a prefix of \code{z_}. Note the rescaling here is by
two standard deviations and not one. The default prefix ("z") can be
changed by way of an argument in the function.

All functions, except for \code{lag_at}, will fail in the absence of a
character vector of a length of one. They are intended to work across multiple
columns instead of just one. If you are wanting to create one new variable,
you should think about using some other \pkg{dplyr} verb on its own.
}
\examples{

set.seed(8675309)
Example <- data.frame(category = c(rep("A", 5),
                                   rep("B", 5),
                                   rep("C", 5)),
                      x = runif(15), y = runif(15),
                      z = sample(1:20, 15, replace=TRUE))

my_vars <- c("x", "y", "z")
center_at(Example, my_vars)

diff_at(Example, my_vars)

diff_at(Example, my_vars, o=3)

lag_at(Example, my_vars)

lag_at(Example, my_vars, o=3)

log_at(Example, my_vars)

log_at(Example, my_vars, plus_1 = TRUE)

mean_at(Example, my_vars)

group_mean_center_at(mean_at(Example, my_vars), my_vars)
# ^ Alternatively, a better way:
# Example \%>\%
#   mean_at(my_vars) \%>\%
#   group_by(category) \%>\%
#   group_mean_center_at(my_vars)

r1sd_at(Example, my_vars)

r2sd_at(Example, my_vars)
}
