% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle.R
\name{mle.stcos}
\alias{mle.stcos}
\title{MLE for STCOS Model}
\usage{
mle.stcos(z, v, H, S, K.inv, init = NULL, optim.control = list())
}
\arguments{
\item{z}{Vector which represents the outcome; assumed to be direct
estimates from the survey.}

\item{v}{Vector which represents direct variance estimates from the survey.}

\item{H}{Matrix of overlaps between source and fine-level supports.}

\item{S}{Design matrix for basis decomposition.}

\item{K.inv}{Inverse of the \eqn{K} matrix, which is the covariance of the
random coefficient \eqn{\eta}}

\item{init}{A list containing the following initial values for the MCMC:
\code{sig2xi}. If not specified, we select an arbitrary initial
value.}

\item{optim.control}{This is passed as the \code{control} argument to
\code{optim}. Note that the value \code{fnscale} is ignored if
specified.}
}
\value{
A list containing maximum likelihood estimates.
}
\description{
MLE for STCOS Model
}
\examples{
\dontrun{
z <- sp$get_z()
v <- sp$get_v()
H <- sp$get_H()
S.reduced <- sp$get_reduced_S() 
K.inv <- sp$get_Kinv(2005:2015)

mle.out <- mle.stcos(z, v, S.reduced, H, K.inv)

sig2K.hat <- mle.out$sig2K.hat
sig2xi.hat <- mle.out$sig2xi.hat
mu.hat -> mle.out$mu.hat
}
}
