% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy-model-expressions.R
\name{tidy_model_expressions}
\alias{tidy_model_expressions}
\title{Expressions with statistics for tidy regression data frames}
\usage{
tidy_model_expressions(
  data,
  statistic = NULL,
  k = 2L,
  effsize.type = "omega",
  ...
)
}
\arguments{
\item{data}{A tidy data frame from regression model object (see
\code{statsExpressions::tidy_model_parameters()}).}

\item{statistic}{Which statistic is to be displayed (either \code{"t"} or \code{"f"}or
\code{"z"} or \code{"chi"}) in the expression.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"eta"} (partial eta-squared) or \code{"omega"} (partial
omega-squared).}

\item{...}{Currently ignored.}
}
\description{
Expressions with statistics for tidy regression data frames
}
\details{
When any of the necessary numeric column values (\code{estimate}, \code{statistic},
\code{p.value}) are missing, for these rows, a \code{NULL} is returned instead of an
expression with empty strings.
}
\note{
This is an \strong{experimental} function and may change in the future. Please do
not use it yet in your workflow.
}
\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# setup
set.seed(123)
library(statsExpressions)

# extract a tidy data frame
df <- tidy_model_parameters(lm(wt ~ am * cyl, mtcars))

# create a column containing expression; the expression will depend on `statistic`
tidy_model_expressions(df, statistic = "t")
tidy_model_expressions(df, statistic = "z")
tidy_model_expressions(df, statistic = "chi")
\dontshow{\}) # examplesIf}
}
