% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_random.R
\name{expr_meta_random}
\alias{expr_meta_random}
\title{Expression and dataframe for random-effects meta-analysis}
\usage{
expr_meta_random(
  data,
  type = "parametric",
  metaBMA.args = list(),
  random = "mixture",
  k = 2L,
  conf.level = 0.95,
  caption = NULL,
  output = "expression",
  ...
)
}
\arguments{
\item{data}{A dataframe. It \strong{must} contain columns named \code{estimate} (effect
sizes or outcomes)  and \code{std.error} (corresponding standard errors). These
two columns will be used for \code{yi}  and \code{sei} arguments in \code{metafor::rma}
(for parametric analysis) or \code{metaplus::metaplus} (for robust analysis).}

\item{type}{Type of statistic expected (\code{"parametric"} or \code{"nonparametric"}
or \code{"robust"} or \code{"bayes"}).Corresponding abbreviations are also accepted:
\code{"p"} (for parametric), \code{"np"} (nonparametric), \code{"r"} (robust), or
\code{"bf"}resp.}

\item{metaBMA.args}{A list of additional arguments to be passed to
\code{metaBMA::meta_random}.}

\item{random}{
The type of random effects distribution. One of "normal","t-dist","mixture", for standard normal, \eqn{t}-distribution or mixture of normals respectively.
}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} confidence/credible intervals (\code{0.95}).}

\item{caption}{Text to display as caption. This argument is relevant only
when \code{output = "caption"}.}

\item{output}{If \code{"expression"}, will return expression with statistical
details, while \code{"dataframe"} will return a dataframe containing the
results.}

\item{...}{Additional arguments passed to the respective meta-analysis
function.}
}
\description{
Expression and dataframe for random-effects meta-analysis
}
\details{
This analysis is carried out using-
\itemize{
\item parametric: \code{metafor::rma}
\item robust: \code{metaplus::metaplus}
\item Bayesian: \code{metaBMA::meta_random}
}
}
\examples{
\donttest{
# setup
set.seed(123)
library(statsExpressions)
library(metaplus)

# renaming to what `statsExpressions` expects
df <- dplyr::rename(mag, estimate = yi, std.error = sei)

# ----------------------- parametric ---------------------------------------

# creating expression
expr_meta_random(data = df, k = 3)

# ----------------------- random -----------------------------------------

# creating expression
expr_meta_random(
  data = df,
  type = "random",
  random = "normal",
  output = "dataframe"
)

# ----------------------- Bayes Factor -----------------------------------

# making subtitle
expr_meta_random(
  data = df,
  type = "bayes",
  k = 3,
  # additional arguments given to `metaBMA`
  metaBMA.args = list(
    iter = 5000,
    summarize = "integrate",
    control = list(adapt_delta = 0.99, max_treedepth = 15)
  )
)
}
}
