% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{expon.slope}
\alias{expon.slope}
\title{Confidence interval for an exponentiated slope}
\usage{
expon.slope(alpha, b, se)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{b}{estimated slope coefficient}

\item{se}{slope standard error}
}
\value{
Returns a 2-row matrix. The first row gives the results for exp(B), and the
the second row gives the results for exp(B) - 1 (as a percent). The columns are:
\itemize{
\item Estimate - estimate of exp(B) or exp(B) - 1
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes confidence intervals for exp(B) - 1 (as a percent) and exp(B)
where B is a population slope coefficient in a binary logit, ordinal
logit, or log-Poisson model. This function is useful with software that
does not have an option to compute exp(B) and exp(B) - 1.
}
\examples{
expon.slope(.05, .502, .0396)

# Should return:
#                   Estimate        LL       UL
# exp(B)            1.652022  1.528651  1.78535
# 100[exp(B) - 1]\% 65.202201 52.865066 78.53502


}
