% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{size.ci.lc.prop.bs}
\alias{size.ci.lc.prop.bs}
\title{Sample size for a between-subjects proportion linear contrast confidence
interval}
\usage{
size.ci.lc.prop.bs(alpha, p, w, v)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{p}{vector of proportion planning values}

\item{w}{desired confidence interval width}

\item{v}{vector of between-subjects contrast coefficients}
}
\value{
Returns the required sample size for each group
}
\description{
Computes the sample size in each group (assuming equal sample sizes) required
to estimate a linear contrast of proportions with desired confidence interval
precision in a between-subjects design. Set the proportion planning values to
.5 for a conservatively large sample size.
}
\examples{
p <- c(.25, .30, .50, .50)
v <- c(.5, .5, -.5, -.5)
size.ci.lc.prop.bs(.05, p, .2, v)

# Should return:
# Sample size per group
#                    87


}
