% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{ci.rel2}
\alias{ci.rel2}
\title{Confidence interval for a 2-group reliability difference}
\usage{
ci.rel2(rel1, ll1, ul1, rel2, ll2, ul2)
}
\arguments{
\item{rel1}{estimated reliability for group 1}

\item{ll1}{lower limit for group 1 reliability}

\item{ul1}{upper limit for group 1 reliability}

\item{rel2}{estimated reliability for group 2}

\item{ll2}{lower limit for group 2 reliability}

\item{ul2}{upper limit for group 2 reliability}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated reliability difference
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a 100(1 - alpha)\% confidence interval for a difference in
population reliabilities in a 2-group design. This function can be
used with any type of reliablity coefficient (e.g., Cronbach alpha,
McDonald omega, intraclass reliablities). The function requires
point estimates and 100(1 - alpha)\% confidence intervals for each
reliability as input.
}
\examples{
ci.rel2(.4, .35, .47, .2, .1, .32)

# Should return:
#      Estimate   LL        UL
# [1,]      0.2 0.07 0.3220656
 

}
\references{
\insertRef{Bonett2015}{statpsych}
}
