% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get_isd_station_data.R
\name{get_isd_station_data}
\alias{get_isd_station_data}
\title{Get met station data from the ISD dataset}
\source{
\url{http://www.ncdc.noaa.gov/isd}\cr
\url{http://www1.ncdc.noaa.gov/pub/data/ish/ish-format-document.pdf}

Calculating Humidity: \cr
\url{https://en.wikipedia.org/wiki/Clausius\%E2\%80\%93Clapeyron_relation#Meteorology_and_climatology}
}
\usage{
get_isd_station_data(station_id, startyear, endyear, full_data = FALSE,
  add_data_report = FALSE, select_additional_data = NULL,
  use_local_files = FALSE, local_file_dir = NULL)
}
\arguments{
\item{station_id}{a station identifier composed of the station's USAF and
WBAN numbers, separated by a hyphen.}

\item{startyear}{the starting year for the collected data.}

\item{endyear}{the ending year for the collected data.}

\item{full_data}{include additional meteorological data found in the
dataset's additional data section?}

\item{add_data_report}{selecting TRUE will provide a data frame with
information on which additional data categories are available for the
selected station during the specified years.}

\item{select_additional_data}{a vector of categories for additional
meteorological data to include (instead of all available categories).}

\item{use_local_files}{option to use data files already available locally.}

\item{local_file_dir}{path to local meteorological data files.}
}
\value{
Returns a data frame with 18 variables. Times are recorded
using the Universal Time Code (UTC) in the source data. Times are adjusted
to local standard time for the station's locale.
\describe{
  \item{usaf}{A character string identifying the fixed weather
    station from the USAF Master Station Catalog.
    USAF is an acronym for United States Air Force.}
  \item{wban}{A character string for the fixed weather
    station NCDC WBAN identifier.
    NCDC is an acronym for National Climatic Data Center.
    WBAN is an acronym for Weather Bureau, Air Force and Navy.}
  \item{year}{A numeric, four digit value giving the year of the
    observation.}
  \item{month}{A numeric value (one or two digits) giving the month
    of the observation.}
  \item{day}{A numeric value (one or two digits) giving the day of the
    month of the observation.}
  \item{hour}{A numeric value (one or two digits) giving the hour of
    the observation.}
  \item{minute}{A numeric value (one or two digits) giving the minute
    of the hour in which the observation was recorded.}
  \item{lat}{Latitude (degrees) rounded to three decimal places.}
  \item{lon}{Longitude (degrees) rounded to three decimal places.}
  \item{elev}{Numeric value for the elevation as measured in meters.
    The minimum value is -400 with a maximum of 8850. Elevation in feet
    can be approximated by \code{elev * 3.28084}}
  \item{wd}{The angle of wind direction, measured in a clockwise
    direction, between true north and the direction from which
    the wind is blowing. For example, \code{wd = 90} indicates the
    wind is blowing from due east. \code{wd = 225} indicates the
    wind is blowing from the south west. The minimum value is 1, and the
    maximum value is 360.}
  \item{ws}{Wind speed in meters per second.  Wind speed in feet per
    second can be estimated by \code{ws * 3.28084}}
  \item{ceil_hgt}{The height above ground level of the lowest clould cover
    or other obscuring phenomena amounting to at least 5/8 sky
    coverate.  Measured in meters.  Unlimited height (no obstruction)
    is denoted by the value 22000}
  \item{temp}{Air temperature measured in degrees Celsius. Conversions
    to degrees Farenheit may be calculated with
    \code{(temp * 9) / 5 + 32}}.
  \item{dew_point}{The temperature in degrees Celsius to which a
    given parcel of air must be cooled at constant pressure and
    water vapor content in order for saturation to occur.}
  \item{atmos_pres}{The air pressure in hectopascals relative to
    Mean Sea Level (MSL)}
  \item{rh}{Relative humidity, measured as a percentage,
    as calculated using the August-Roche-Magnus approximation}
  \item{time}{A POSIXct object with the date-time of the observation.}
}
}
\description{
Obtain one or more years of meteorological data for a station
from the NCEI Integrated Surface Dataset (ISD).
}
\examples{
\dontrun{
# Obtain a listing of all stations within a bounding box and
# then isolate a single station and obtain a string with the
# \\code{usaf} and \\code{wban} identifiers.
# Pass that identifier string to the \\code{get_isd_station_data}
# function to obtain a data frame of meteorological data for
# the year 2010
stations_within_domain <-
  get_isd_stations(lower_lat = 49.000,
                   upper_lat = 49.500,
                   lower_lon = -123.500,
                   upper_lon = -123.000)

cypress_bowl_snowboard_stn <-
  select_isd_station(stn_df = stations_within_domain,
                     name = "cypress bowl snowboard")

cypress_bowl_snowboard_stn_met_data <-
  get_isd_station_data(station_id = cypress_bowl_snowboard_stn,
                       startyear = 2010,
                       endyear = 2010)

# Get a vector of available additional data categories for a station
# during the specied years
additional_data_categories <-
  get_isd_station_data(station_id = "722315-53917",
                       startyear = 2014,
                       endyear = 2015,
                       add_data_report = TRUE)

# Obtain two years of data from data files stored on disk (in this
# case, inside the package itself)
df_mandatory_data_local <-
  get_isd_station_data(
    station_id = "999999-63897",
    startyear = 2013,
    endyear = 2014,
    use_local_files = TRUE,
    local_file_dir = system.file(package = "stationaRy")
)
}
}

