#' Growth of sugarbeet in weed-infested and weed-free conditions
#'
#' A data frame with 18 observations on the following 3 variables:
#'
#' \itemize{
#'   \item DAE. numeric: Days After Emergence
#'   \item weightInf. numeric: weight of crop biomass on the weed infested plots
#'   \item weightFree. numeric: weight of crop biomass on the weed free plots
#'  }
#'
#' @docType data
#' @keywords datasets
#' @name beetGrowth
#' @usage data("beetGrowth")
#' @format A data frame with 18 rows and 3 variables
#' @references Covarelli, G., Onofri, A., 1998. Effects of timing of weed removal and emergence in sugarbeet, in: Proceedings 6th EWRS Mediterranean Symposium, Montpellier, 13-15 May 1998. EWRS, pp. 65–72.
#' @examples
#' data(beetGrowth)
#' mod3 <- nls(weightInf ~ NLS.L3(DAE, b, c, d), data = beetGrowth)

#'
"beetGrowth"

#' Degradation of metamitron in soil with co-applied herbicides
#'
#' The dataset describes the degradation of metamitron in soil at 20°C
#' with several co-applied herbicides. It is a synthetic dataset,
#' that was generated by Monte Carlo methods, starting from the
#' observed data in Vischetti et al., 1996.
#' A data frame with 96 observations on the following 3 variables:
#'
#' \itemize{
#'   \item Time. numeric: Days from start of incubation
#'   \item Herbicide. factor: M is 'metamitron', MP is 'metamitron+phenmedipham', MC is 'metamitron+chloridazon' and MPC is 'metamitron+phenmedipham+chloridazon'
#'   \item Conc. numeric: residual concentration of metamitron
#'  }
#'
#' @docType data
#' @keywords datasets
#' @name metamitron
#' @usage data("metamitron")
#' @format A data frame with 96 rows and 3 variables
#' @references Vischetti, C., Marini, M., Businelli, M., Onofri, A., 1996. The effect of temperature and co-applied herbicides on the degradation rate of phenmedipham, chloridazon and metamitron in a clay loam soil in the laboratory, in: Re, A.D., Capri, E., Evans, S.P., Trevisan, M. (Eds.), “The Environmental Phate of Xenobiotics”, Proceedings X Symposium on Pesticide Chemistry, Piacenza. La Goliardica Pavese, Piacenza, pp. 287–294.
#' @examples
#' data("metamitron")
#' metamitron
#'
"metamitron"

#' Soil degradation kinetic for a herbicide
#'
#' A data frame with 24 observations on the following 2 variables:
#'
#' \itemize{
#'   \item Time. numeric: Days from start of incubation
#'   \item Conc. numeric: residual concentration
#'  }
#'
#' @docType data
#' @keywords datasets
#' @name degradation
#' @usage data("degradation")
#' @format A data frame with 24 rows and 2 variables
#' @examples
#' data("degradation")
#' degradation
#'
"degradation"

#' Efficacy of the mixture of two herbicides
#'
#' Two herbicides are used alone and in mixture. It is a data frame
#' with 16 observations on the following 2 variables:
#'
#' \itemize{
#'   \item Treat. Factor: the treatment levels
#'   \item Weight. numeric: the weight of weeds
#'  }
#'
#' @docType data
#' @keywords datasets
#' @name mixture
#' @usage data("mixture")
#' @format A data frame with 24 rows and 2 variables
#' @examples
#' data("degradation")
#' degradation
#'
"mixture"

