% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NcOpener.R
\name{NcOpener}
\alias{NcOpener}
\title{NetCDF file opener for 'startR'}
\usage{
NcOpener(file_path)
}
\arguments{
\item{file_path}{A character string indicating the path to the data file to 
read. See details in the documentation of the parameter 'file_opener' of the 
function Start().}
}
\value{
An open connection to a NetCDF file with additional header 
 information as returned by nc_open() in the package 'ncdf4'. See details in 
 the documentation of the parameter 'file_opener' of the function Start().
}
\description{
This is a file opener function for NetCDF files, intended for use as parameter 
'file_opener' in a Start() call. This function complies with the input/output 
interface required by Start() defined in the documentation for the parameter 
'file_opener'.\cr\cr
This function uses the function NcOpen() in the package 'easyNCDF', which in 
turn uses nc_open() in the package 'ncdf4'.
}
\examples{
data_path <- system.file('extdata', package = 'startR')
path_obs <- file.path(data_path, 'obs/monthly_mean/tos/tos_200011.nc')
connection <- NcOpener(path_obs)
NcCloser(connection)
}
\seealso{
\code{\link{NcDimReader}} \code{\link{NcDataReader}} 
 \code{\link{NcCloser}} \code{\link{NcVarReader}}
}
