% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_schema_rename.R
\name{rename_measures}
\alias{rename_measures}
\alias{rename_measures.star_schema}
\title{Rename measures}
\usage{
rename_measures(st, measures, new_names)

\method{rename_measures}{star_schema}(st, measures, new_names)
}
\arguments{
\item{st}{A \code{star_schema} object.}

\item{measures}{A vector of measure names.}

\item{new_names}{A vector of new measure names.}
}
\value{
A \code{star_schema} object.
}
\description{
Set new names of some measures in facts.
}
\examples{

st <-
  st_mrs_age |> rename_measures(measures = c("deaths"),
                                 new_names = c("n_deaths"))

}
\seealso{
Other rename functions: 
\code{\link{get_dimension_attribute_names}()},
\code{\link{get_measure_names}()},
\code{\link{rename_dimension_attributes}()},
\code{\link{rename_dimension}()},
\code{\link{rename_fact}()}
}
\concept{rename functions}
