% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_schema_role_playing_dimension.R
\name{role_playing_dimension}
\alias{role_playing_dimension}
\alias{role_playing_dimension.star_schema}
\title{Define a role playing dimension in a \code{star_schema} object}
\usage{
role_playing_dimension(st, dim_names, name = NULL, attributes = NULL)

\method{role_playing_dimension}{star_schema}(st, dim_names, name = NULL, attributes = NULL)
}
\arguments{
\item{st}{A \code{star_schema} object.}

\item{dim_names}{A vector of dimension names.}

\item{name}{A string, name of the role playing dimension.}

\item{attributes}{A vector of attribute names of the role playing dimension.}
}
\value{
A \code{star_schema} object.
}
\description{
Given a list of \code{star_schema} dimension names, all with the same structure, a
role playing dimension with the indicated name and attributes is generated.
The original dimensions become role dimensions defined from the new role
playing dimension.
}
\details{
After definition, all role dimensions have the same virtual instances (those
of the role playing dimension). The foreign keys in facts are adapted to this
new situation.
}
\examples{

st <- star_schema(mrs_age, dm_mrs_age) |>
  role_playing_dimension(
    dim_names = c("when", "when_available"),
    name = "When Common",
    attributes = c("Date", "Week", "Year")
  )

st <- star_schema(mrs_cause, dm_mrs_cause) |>
  role_playing_dimension(
    dim_names = c("when", "when_received", "when_available"),
    name = "when_common",
    attributes = c("date", "week", "year")
  )

}
\seealso{
Other star schema and constellation definition functions: 
\code{\link{character_dimensions}()},
\code{\link{constellation}()},
\code{\link{snake_case}()},
\code{\link{star_schema}()}
}
\concept{star schema and constellation definition functions}
