% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterReforms.R
\name{form_boldA}
\alias{form_boldA}
\title{Form the \eqn{((dp)x(dp))} "bold A" matrices related to the VAR processes}
\usage{
form_boldA(p, M, d, all_A)
}
\arguments{
\item{p}{the autoregressive order of the model}

\item{M}{the number of regimes}

\item{d}{the number of time series in the system, i.e., the dimension}

\item{all_A}{4D array containing all coefficient matrices \eqn{A_{m,i}}, obtained from \code{pick_allA}.}
}
\value{
Returns 3D array containing the \eqn{((dp)x(dp))} "bold A" matrices related to each component VAR-process.
 The matrix \strong{\eqn{A_{m}}} can be obtained by choosing \code{[, , m]}.
}
\description{
\code{form_boldA} creates the "bold A" (companien form) coefficient matrices related to
  VAR processes.
}
\details{
The "bold A" (companion form) matrix is given, for instance, in Lütkepohl (2005, p. 15).
}
\section{Warning}{

 No argument checks!
}

\references{
\itemize{
   \item Lütkepohl H. 2005. New Introduction to Multiple Time Series Analysis, \emph{Springer}.
 }
}
\keyword{internal}
