% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group-by.r
\name{group_by}
\alias{group_by}
\alias{group_by_}
\title{Group a (survey) dataset by one or more variables.}
\arguments{
\item{.data}{A tbl}

\item{...}{variables to gorup by. All tbls accept variable names, some will
also accept functions of variables. Duplicated groups will be silently dropped.}

\item{add}{By default, when \code{add = FALSE}, \code{group_by} will override
existing groups. To instead add to the existing groups, use \code{add = TRUE}}

\item{.dots}{Used to work around non-standard evaluation. See
\code{vignette("nse", package = "dplyr")} for details.}
}
\description{
Most data operations are useful when done on groups defined by variables
in the dataset. The \code{group_by} function takes an existing table (or
svy_table) and converts it to a grouped version, where operations are
performed "by group".
}
\details{
See \code{\link[dplyr]{group_by}} for more information about grouping
regular data tables.

On \code{tbl_svy} objects, \code{group_by} sets up the object for
operations similar to those allowed in \code{\link[survey]{svyby}}.
}
\examples{
# Examples of svy_tbl group_by
library(survey)
data(api)
dstrata <- apistrat \%>\%
  as_survey_design(strata = stype, weights = pw) \%>\%
  group_by(stype)

  dstrata \%>\%
    summarise(api_diff = survey_mean(api00 - api99))
}
\seealso{
\code{\link[dplyr]{group_by}} for information about group_by on normal data tables.
}

