% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_player_recent_.R
\name{get_player_recent_}
\alias{get_player_recent_}
\title{Get a player's recent data from SquashInfo}
\usage{
get_player_recent_(
  level = c("results", "matches", "games"),
  player = NULL,
  rank = NULL,
  category = NULL
)
}
\arguments{
\item{level}{character string indicating the level of detail of the data to be returned. Must be one of "results", "matches", or "games".}

\item{player}{character string of player name.}

\item{rank}{single integer or vector of integers indicating the rank of the PSA player(s) to return.}

\item{category}{character string indicating the competition category. Must be one of "both", "mens", or "womens".}
}
\value{
Tibble containing the player rank, player name, player's seeding, round reached, event name, event date, event location, and event tour.
}
\description{
Given level of detail (e.g. 'results', 'matches', 'games'), the full name or rank of a player, and the competition category, \code{get_player_recent_()} returns the recent event data for PSA ranked players.
}
