% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmtestspsur.R
\name{lmtestspsur}
\alias{lmtestspsur}
\alias{lmtestspsur.formula}
\alias{lmtestspsur.default}
\title{Testing for the presence of spatial effects in Seemingly 
 Unrelated Regressions}
\usage{
lmtestspsur(...)

\method{lmtestspsur}{formula}(
  formula,
  data,
  listw,
  na.action,
  time = NULL,
  Tm = 1,
  zero.policy = NULL,
  R = NULL,
  b = NULL,
  ...
)

\method{lmtestspsur}{default}(Y, X, G, N, Tm = 1, listw, p, R = NULL, b = NULL, ...)
}
\arguments{
\item{...}{further arguments passed to the method.}

\item{formula}{An object type \code{\link[Formula]{Formula}} 
similar to objects created with the package \pkg{Formula} 
describing the equations to be estimated in the model. 
This model may contain several responses (explained 
variables) and a varying number of regressors in each equation.}

\item{data}{An object of class data.frame or a matrix.}

\item{listw}{A \code{listw} object created for example by 
\code{\link[spdep]{nb2listw}} from \pkg{spatialreg} package; if 
\code{\link[spdep]{nb2listw}} not given, set to 
the same spatial weights as the \code{listw} argument. It can
also be a spatial weighting matrix of order \emph{(NxN)} instead of
a \code{listw} object. Default = \code{NULL}.}

\item{na.action}{A function (default \code{options("na.action")}),
can also be \code{na.omit} or \code{na.exclude} with consequences 
 for residuals and fitted values. It may be necessary to set 
 \code{zero.policy} to \code{TRUE} because this subsetting may 
 create no-neighbour observations.}

\item{time}{time index for the spatial panel SUR data.}

\item{Tm}{Number of time periods.}

\item{zero.policy}{Similar to the corresponding parameter of 
\code{\link[spatialreg]{lagsarlm}} function in \pkg{spatialreg} package. 
If \code{TRUE} assign zero to the lagged value of zones without 
neighbours, if \code{FALSE} assign \code{NA} - causing 
\code{spsurml()} to terminate with an error. Default = \code{NULL}.}

\item{R}{A row vector of order \emph{(1xpr)} with  the set of 
\emph{r} linear constraints on the \emph{beta} parameters. The 
\emph{first} restriction appears in the first \emph{p} terms,
the second restriction in the next \emph{p} terms and so on. 
Default = \code{NULL}.}

\item{b}{A column vector of order \emph{(rx1)} with the values of 
the linear restrictions on the \emph{beta} parameters. 
Default = \code{NULL}.}

\item{Y}{A column vector of order \emph{(NTmGx1)}, with the 
observations of the explained variables. The ordering of the data 
must be (first) equation, (second) time dimension and (third) 
cross-sectional/spatial units. The specification of \emph{Y} is 
only necessary if not available a \code{\link[Formula]{Formula}}
and a data frame. Default = \code{NULL}.}

\item{X}{A data matrix of order \emph{(NTmGxp)} with the observations
of the regressors. The number of covariates in the SUR model is 
\emph{p} = \eqn{sum(p_{g})} where \emph{\eqn{p_{g}}} is the number 
of regressors (including the intercept) in the g-th equation, 
\emph{g = 1,...,G}). The specification of "X" is only 
necessary if not available a \code{\link[Formula]{Formula}} and a 
data frame. Default = \code{NULL}.}

\item{G}{Number of equations.}

\item{N}{Number of cross-section or spatial units}

\item{p}{Number of regressors by equation, including the intercept. 
\emph{p} can be a row vector of order \emph{(1xG)}, if the number 
 of regressors is not the same for all the equations, or a scalar, 
 if the \emph{G} equations have the same number of regressors. The 
specification of \emph{p} is only necessary if not available a 
\code{\link[Formula]{Formula}} and a data frame.}
}
\value{
A list of \code{htest} objects each one including the Wald
  statistic, the corresponding p-value and the degrees of
  freedom.
}
\description{
The function \code{\link{spsurml}}  reports a collection of 
 Lagrange Multipliers designed to test  for the presence of different 
 forms of spatial dependence in a \emph{SUR} model of the "sim" type. 
 That is, the approach of this function is from 
 \emph{'specific to general'}. As said, the model of the null hypothesis 
 is the "sim" model whereas the model of the alternative depends on 
 the effect whose omission we want to test.

The collection of Lagrange Multipliers obtained by \code{lmtestspsur} 
are standard in the literature and take into account the multivariate 
nature of the \emph{SUR} model. As a limitation, note that each 
Multiplier tests for the omission of the same spatial effects in all 
the cross-sections of the \emph{G} equations.
}
\details{
\code{\link{lmtestspsur}} tests for the omission of spatial 
 effects in the "sim" version of the \emph{SUR} model: \cr

    \deqn{y_{tg} = X_{tg} \beta_{g} + u_{tg}}
    \deqn{E[u_{tg}u_{th}']= \sigma_{gh}I_{N}  \quad E[u_{tg}u_{sh}']= 0 
          \mbox{ if } t ne s}

where \eqn{y_{tg}} and \eqn{u_{tg}} are \emph{(Nx1)} vectors, 
corresponding to the g-th equation and time period t;
\eqn{X_{tg}} is the matrix of exogenous variables, of order 
\emph{\eqn{(Nxp_{g})}}. Moreover, \eqn{\beta_{g}} is an unknown
\emph{\eqn{(p_{g}x1)}} vector of coefficients and \eqn{\sigma_{gh}I_{N}} 
the covariance between equations \emph{g} and \emph{h},
being \eqn{\sigma_{gh}} and scalar and \eqn{I_{N}} the identity 
matrix of orden N.


The Lagrange Multipliers reported by this function are the followings:

  \itemize{
    \item \strong{LM-SUR-LAG}: Tests for the omission of a spatial lag of 
     the explained variable in the right hand side of the "sim" equation. 
     The model of the alternative is: \cr

    \eqn{y_{tg} = \rho_{g}Wy_{tg} + X_{tg} \beta_{g} + u_{tg}}

      The null and alternative hypotheses are:

         \eqn{H_{0}: \rho_{g}=0 (forall g)} vs  
         \eqn{H_{A}: \rho_{g} ne 0 (exist g)}

     \item \strong{LM-SUR-ERR}: Tests for the omission of spatial 
      dependence in the equation of the errors of the "sim" model. The 
      model of the alternative is:

    \eqn{y_{tg} = X_{tg} \beta_{g} + u_{tg}}; 
    \eqn{u_{tg}= \lambda_{g}Wu_{tg}+\epsilon_{tg}}

      The null and alternative hypotheses are:

         \eqn{H_{0}: \lambda_{g}=0 (forall g)} vs  
         \eqn{H_{A}: \lambda_{g}  ne 0 (exist g)}

     \item \strong{LM-SUR-SARAR}: Tests for the simultaneous omission of 
     a spatial lag of the explained variable in the right hand side of 
     the "sim" equation and spatial dependence in the equation of the 
     errors. The model of the alternative is:


    \eqn{y_{tg} = \rho_{g}Wy_{tg}+X_{tg} \beta_{g} + u_{tg}}; 
    \eqn{u_{tg}= \lambda_{g}Wu_{tg}+\epsilon_{tg}}

      The null and alternative hypotheses are:

     \eqn{H_{0}: \rho_{g}=\lambda_{g}=0 (forall g)} vs  
     \eqn{H_{A}: \rho_{g} ne 0 or \lambda_{g} ne 0 (exist g)}

     \item
     \strong{LM*-SUR-SLM} and \strong{LM*-SUR-SEM}: These two test are 
      the robustifyed version of the original, raw Multipliers, 
      \strong{LM-SUR-SLM} and \strong{LM-SUR-SEM}, which can be severely 
      oversized if the respective alternative hypothesis is misspeficied 
      (this would be the case if, for example, we are testing for omitted 
      lags of the explained variable whereas the problem is that there is 
      spatial dependence in the errors, or viceversa). The null and 
      alternative hypotheses of both test are totally analogous to their
      twin non robust Multipliers.
    }
}
\examples{
#################################################
######## CROSS SECTION DATA (G>1; Tm=1) # #######
#################################################

#### Example 1: Spatial Phillips-Curve. Anselin (1988, p. 203)
rm(list = ls()) # Clean memory
data("spc")
Tformula <- WAGE83 | WAGE81 ~ UN83 + NMR83 + SMSA | UN80 + NMR80 + SMSA
lwspc <- spdep::mat2listw(Wspc, style = "W")
lmtestspsur(formula = Tformula, data = spc, listw = lwspc)

## VIP: The output of the whole set of the examples can be examined 
## by executing demo(demo_lmtestspsur, package="spsur")

\donttest{
#################################################
######## PANEL DATA (G>1; Tm>1)          ########
#################################################

#### Example 2: Homicides & Socio-Economics (1960-90)
# Homicides and selected socio-economic characteristics for
# continental U.S. counties.
# Data for four decennial census years: 1960, 1970, 1980 and 1990.
# https://geodacenter.github.io/data-and-lab/ncovr/
data(NCOVR, package="spsur")
nbncovr <- spdep::poly2nb(NCOVR.sf, queen = TRUE)
### Some regions with no links...
lwncovr <- spdep::nb2listw(nbncovr, style = "W", zero.policy = TRUE)
### With different number of exogenous variables in each equation
Tformula <- HR70 | HR80  | HR90 ~ PS70 + UE70 | PS80 + UE80 +RD80 |
            PS90 + UE90 + RD90 + PO90
lmtestspsur(formula = Tformula, data = NCOVR.sf, 
            listw = lwncovr)

#################################################################
######### PANEL DATA: TEMPORAL CORRELATIONS (G=1; Tm>1) ########
#################################################################

##### Example 3: NCOVR in panel data form
Year <- as.numeric(kronecker(c(1960,1970,1980,1990), 
                   matrix(1,nrow = dim(NCOVR.sf)[1])))
HR <- c(NCOVR.sf$HR60,NCOVR.sf$HR70,NCOVR.sf$HR80,NCOVR.sf$HR90)
PS <- c(NCOVR.sf$PS60,NCOVR.sf$PS70,NCOVR.sf$PS80,NCOVR.sf$PS90)
UE <- c(NCOVR.sf$UE60,NCOVR.sf$UE70,NCOVR.sf$UE80,NCOVR.sf$UE90)
NCOVRpanel <- as.data.frame(cbind(Year,HR,PS,UE))
Tformula <- HR ~ PS + UE
lmtestspsur(formula = Tformula, data = NCOVRpanel, time = Year, 
listw = lwncovr)
}

}
\references{
\itemize{
    \item Mur, J., López, F., and Herrera, M. (2010). Testing for spatial
      effects in seemingly unrelated regressions.
      \emph{Spatial Economic Analysis}, 5(4), 399-440.
      <doi:10.1080/17421772.2010.516443>
      
     \item López, F.A., Mur, J., and Angulo, A. (2014). Spatial model
       selection strategies in a SUR framework. The case of regional
       productivity in EU. \emph{Annals of Regional Science}, 53(1),
       197-220.
       <doi:10.1007/s00168-014-0624-2>
       
       \item Anselin, L. (1988) A test for spatial autocorrelation in seemingly unrelated 
       regressions \emph{Economics Letters} 28(4), 335-341.
       <doi:10.1016/0165-1765(88)90009-2> 
        
       \item Anselin, L. (1988) \emph{Spatial econometrics: methods and models} 
       Chap. 9 Dordrecht
       
       \item Anselin, L. (2016) Estimation and Testing in the Spatial Seemingly 
      Unrelated Regression (SUR). \emph{Geoda Center for Geospatial Analysis 
      and Computation, Arizona State University}. Working Paper 2016-01.
      <doi:10.13140/RG.2.2.15925.40163>
  }
}
\seealso{
\code{\link{spsurml}}, \code{\link{anova}}
}
\author{
\tabular{ll}{
  Fernando López  \tab \email{fernando.lopez@upct.es} \cr
  Román Mínguez  \tab \email{roman.minguez@uclm.es} \cr
  Jesús Mur  \tab \email{jmur@unizar.es} \cr
  }
}
