% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimCORR.R
\name{optimCORR}
\alias{optimCORR}
\alias{objCORR}
\alias{CORR}
\title{Optimization of sample configurations for spatial trend identification and estimation (I)}
\usage{
optimCORR(points, candi, covars, strata.type = "area",
  use.coords = FALSE, schedule = scheduleSPSANN(), plotit = FALSE,
  track = FALSE, boundary, progress = "txt", verbose = FALSE)

objCORR(points, candi, covars, strata.type = "area",
  use.coords = FALSE)
}
\arguments{
\item{points}{Integer value, integer vector, data frame or matrix, or list.
\itemize{
\item Integer value. The number of points. These points will be randomly sampled from \code{candi} to form
the starting sample configuration.
\item Integer vector. The row indexes of \code{candi} that correspond to the points that form the starting
sample configuration. The length of the vector defines the number of points.
\item Data frame or matrix. An object with three columns in the following order: \code{[, "id"]}, the
row indexes of \code{candi} that correspond to each point, \code{[, "x"]}, the projected x-coordinates, and
\code{[, "y"]}, the projected y-coordinates.
\item List. An object with two named sub-arguments: \code{fixed}, a data frame or matrix with the projected
x- and y-coordinates of the existing sample configuration -- kept fixed during the optimization --, and
\code{free}, an integer value defining the number of points that should be added to the existing sample
configuration -- free to move during the optimization.
}}

\item{candi}{Data frame or matrix with the candidate locations for the jittered points. \code{candi} must
have two columns in the following order: \code{[, "x"]}, the projected x-coordinates, and \code{[, "y"]},
the projected y-coordinates.}

\item{covars}{Data frame or matrix with the covariates in the columns.}

\item{strata.type}{(Optional) Character value setting the type of stratification that should be used to
create the marginal sampling strata (or factor levels) for the numeric covariates. Available options are
\code{"area"}, for equal-area, and \code{"range"}, for equal-range. Defaults to \code{strata.type = "area"}.}

\item{use.coords}{(Optional) Logical value. Should the spatial x- and y-coordinates be used as covariates?
Defaults to \code{use.coords = FALSE}.}

\item{schedule}{List with 11 named sub-arguments defining the control parameters of the cooling schedule.
See \code{\link[spsann]{scheduleSPSANN}}.}

\item{plotit}{(Optional) Logical for plotting the optimization results, including a) the progress of the
objective function, and b) the starting (gray circles) and current sample configuration (black dots), and
the maximum jitter in the x- and y-coordinates. The plots are updated at each 10 jitters. When adding
points to an existing sample configuration, fixed points are indicated using black crosses. Defaults to
\code{plotit = FALSE}.}

\item{track}{(Optional) Logical value. Should the evolution of the energy state be recorded and returned
along with the result? If \code{track = FALSE} (the default), only the starting and ending energy states
are returned along with the results.}

\item{boundary}{(Optional) SpatialPolygon defining the boundary of the spatial domain. If missing and
\code{plotit = TRUE}, \code{boundary} is estimated from \code{candi}.}

\item{progress}{(Optional) Type of progress bar that should be used, with options \code{"txt"}, for a text
progress bar in the R console, \code{"tk"}, to put up a Tk progress bar widget, and \code{NULL} to omit the
progress bar. A Tk progress bar widget is useful when using parallel processors. Defaults to
\code{progress = "txt"}.}

\item{verbose}{(Optional) Logical for printing messages about the progress of the optimization. Defaults to
\code{verbose = FALSE}.}
}
\value{
\code{optimCORR} returns an object of class \code{OptimizedSampleConfiguration}: the optimized sample
configuration with details about the optimization.

\code{objCORR} returns a numeric value: the energy state of the sample configuration -- the objective
function value.
}
\description{
Optimize a sample configuration for spatial trend identification and estimation. A criterion is defined so
that the sample reproduces the bivariate association/correlation between the covariates (\bold{CORR}).
}
\details{
Details about the mechanism used to generate a new sample configuration out of the current sample
configuration by randomly perturbing the coordinates of a sample point are available in the help page of
\code{\link[spsann]{spJitter}}.

\subsection{Association/Correlation between covariates}{
The \emph{correlation} between two numeric covariates is measured using the Pearson's \emph{r}, a
descriptive statistic that ranges from \eqn{-1} to \eqn{+1}. This statistic is also known as the linear
correlation coefficient.

When the set of covariates includes factor covariates, all numeric covariates are transformed into factor
covariates. The factor levels are defined using the marginal sampling strata created from one of the two
methods available (equal-area or equal-range strata).

The \emph{association} between two factor covariates is measured using the Cramér's \emph{V}, a descriptive
statistic that ranges from \eqn{0} to \eqn{+1}. The closer to \eqn{+1} the Cramér's \emph{V} is, the
stronger the association between two factor covariates.

The main weakness of using the Cramér's \emph{V} is that, while the Pearson's \emph{r} shows the degree
and direction of the association between two covariates (negative or positive), the Cramér's \emph{V} only
measures the degree of association (weak or strong). The effect of replacing the Pearson's \emph{r} with
the Cramér's \emph{V} on the spatial modelling outcome still is poorly understood.
}
}
\note{
The distance between two points is computed as the Euclidean distance between them. This computation
assumes that the optimization is operating in the two-dimensional Euclidean space, i.e. the coordinates of
the sample points and candidate locations should not be provided as latitude/longitude. \pkg{spsann} has no
mechanism to check if the coordinates are projected: the user is responsible for making sure that this
requirement is attained.
}
\examples{
data(meuse.grid, package = "sp")
candi <- meuse.grid[1:1000, 1:2]
covars <- meuse.grid[1:1000, 5]
schedule <- scheduleSPSANN(
  initial.temperature = 5, chains = 1, x.max = 1540, y.max = 2060, 
  x.min = 0, y.min = 0, cellsize = 40)
set.seed(2001)
res <- optimCORR(
  points = 10, candi = candi, covars = covars, use.coords = TRUE, 
  schedule = schedule)
objSPSANN(res) - objCORR(
  points = res, candi = candi, covars = covars, use.coords = TRUE)
}
\references{
Cramér, H. \emph{Mathematical methods of statistics}. Princeton: Princeton University Press, p. 575, 1946.

Everitt, B. S. \emph{The Cambridge dictionary of statistics}. Cambridge: Cambridge University Press, p. 432,
2006.
}
\seealso{
\code{\link[pedometrics]{cramer}}, \code{\link[spsann]{optimACDC}}
}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
\concept{simulated annealing}
\concept{spatial trend}
\keyword{iteration}
\keyword{optimize}
\keyword{spatial}
