% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsUtil.R
\name{spsOption}
\alias{spsOption}
\title{Get or set SPS options}
\usage{
spsOption(opt, value = NULL, empty_is_false = TRUE)
}
\arguments{
\item{opt}{string, length 1, what option you want to get or set}

\item{value}{if this is not \code{NULL}, this function will set the
option you choose to this value}

\item{empty_is_false}{bool, when trying to get an option value, if the
option is \code{NULL}, \code{NA}, \code{""} or length is 0, return \code{FALSE}?}
}
\value{
return the option value if value exists; return \code{FALSE} if the value
is empty, like \code{NULL}, \code{NA}, \code{""}; return \code{NULL} if \code{empty_is_false = FALSE};
see \link{emptyIsFalse}

If \code{value != NULL} will set the option to this new value, no returns.
}
\description{
Get or set SPS options
}
\examples{
spsOption("test1") # get a not existing option
spsOption("test1", 1) # set the value
spsOption("test1") # get the value again
spsOption("test2")
spsOption("test2", empty_is_false = FALSE)
}
