% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsUIcollections.R
\name{bsHoverPopover}
\alias{bsHoverPopover}
\title{Bootstrap popover trigger on hover instead of click}
\usage{
bsHoverPopover(
  tag,
  title = NULL,
  content = NULL,
  placement = "top",
  trigger = "hover",
  ...
)
}
\arguments{
\item{tag}{\link[htmltools:tag]{htmltools::tag}, generally htmltools::tags$button() or htmltools::tags$a(),
or \code{\link[shiny:actionButton]{shiny::actionButton()}}}

\item{title}{character, title for the popover, generally text}

\item{content}{character, content for the popover body, can be HTML}

\item{placement}{character, placement of the popover with respect to \code{tag}}

\item{trigger}{trigger method, default "hover", one of click | hover |
focus | manual.}

\item{...}{other named arguments, passed to \code{\link[bsplus:bs_set_data]{bsplus::bs_set_data()}}}
}
\value{
shiny element
}
\description{
enhanced Bootstrap 3 popover by hovering, see
\link[bsplus:bs_embed_popover]{bsplus::bs_embed_popover} for details. Everything is similar but has
additional trigger method, default "hover". Original method only works with
"click" on buttons.
}
\examples{
if(interactive()){
    library(shiny)
    ui <- fluidPage(
        column(2),
        column(
            8,
            actionButton('a', 'On button') \%>\%
                bsHoverPopover(
                    title = "title a",
                    content = "popover works on a button",
                    placement = "bottom"
                ),
            tags$a("On link") \%>\%
                bsHoverPopover(
                    title = "title b",
                    content = "popover works on a link",
                    placement = "bottom"
                )
        )

    )
    server <- function(input, output, session) {}
    shinyApp(ui, server)
}
}
