% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_ttest.R
\name{seq_ttest}
\alias{seq_ttest}
\title{Sequential Probability Ratio Test using t-statistic}
\usage{
seq_ttest(
  x,
  y = NULL,
  data = NULL,
  mu = 0,
  d,
  alpha = 0.05,
  power = 0.95,
  alternative = "two.sided",
  paired = FALSE,
  na.rm = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{x}{Works with two classes: \code{numeric} and \code{formula}. Therefore you can
write \code{"x"} or \code{"x~y"}.
\itemize{
\item \code{"numeric input"}: a (non-empty) numeric vector of data values.
\item \code{"formula input"}: a formula of the form lhs ~ rhs where lhs is a numeric
variable giving the data values and rhs either 1 for a one-sample test or a
factor with two levels giving the corresponding groups.
}}

\item{y}{an optional (non-empty) numeric vector of data values.}

\item{data}{an optional \code{data.frame}, which you can use only in combination
with a \code{"formula input"} in argument \code{x}.}

\item{mu}{a number indicating the true value of the mean (or difference in
means if you are performing a two sample test).}

\item{d}{a number indicating the specified effect size (Cohen's d)}

\item{alpha}{the type I error. A number between 0 and 1.}

\item{power}{1 - beta (beta is the type II error probability). A number
between 0 and 1.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of \code{two.sided} (default), \code{greater} or \code{less}.
You can specify just the initial letter.}

\item{paired}{a logical indicating whether you want a paired t-test.}

\item{na.rm}{a logical value indicating whether \code{NA} values should be
stripped before the computation proceeds.}

\item{verbose}{a logical value whether you want a verbose output or not.}
}
\value{
An object of the S4 class \code{\linkS4class{seq_ttest_results}}. Click on the
class link to see the full description of the slots.
To get access to the object use the
\code{@}-operator or \verb{[]}-brackets instead of \code{$}.
See the examples below.
}
\description{
Performs one and two sample sequential t-tests on vectors of
data.
}
\examples{
# set seed --------------------------------------------------------------------
set.seed(333)

# load library ----------------------------------------------------------------
library(sprtt)

# one sample: numeric input ---------------------------------------------------
treatment_group <- rnorm(20, mean = 0, sd = 1)
results <- seq_ttest(treatment_group, mu = 1, d = 0.8)

# get access to the slots -----------------------------------------------------
# @ Operator
results@likelihood_ratio

# [] Operator
results["likelihood_ratio"]

# two sample: numeric input----------------------------------------------------
treatment_group <- stats::rnorm(20, mean = 0, sd = 1)
control_group <- stats::rnorm(20, mean = 1, sd = 1)
seq_ttest(treatment_group, control_group, d = 0.8)

# two sample: formula input ---------------------------------------------------
stress_level <- stats::rnorm(20, mean = 0, sd = 1)
sex <- as.factor(c(rep(1, 10), rep(2, 10)))
seq_ttest(stress_level ~ sex, d = 0.8)

# NA in the data --------------------------------------------------------------
stress_level <- c(NA, stats::rnorm(20, mean = 0, sd = 2), NA)
sex <- as.factor(c(rep(1, 11), rep(2, 11)))
seq_ttest(stress_level ~ sex, d = 0.8, na.rm = TRUE)

# work with dataset (data are in the package included) ------------------------
seq_ttest(monthly_income ~ sex, data = df_income, d = 0.8)
}
