% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normmix_plots.R
\name{plot.normmix}
\alias{plot.normmix}
\title{Plot a mixture of normal components}
\usage{
\method{plot}{normmix}(x, xlim, ylim, contour = FALSE, truncate = FALSE,
  open_new_window = FALSE, grayscale = FALSE, L = 256,
  title1 = "Mixture with normal components", whichplots = 2, ...)
}
\arguments{
\item{x}{Object of class \code{normmix}.}

\item{xlim, ylim}{The observation window.}

\item{contour}{Logical flag requesting the countour plot only.}

\item{truncate}{Logical flag requesting that the components are truncated within the window.}

\item{open_new_window}{Open a new window for the plot.}

\item{grayscale}{Plot in gray scale. Default is FALSE (use colors).}

\item{L}{Length of the side of the square grid.
The intensity is calculated on an L * L grid.
The larger this value is, the better the picture resolution.}

\item{title1}{Optional title for the 3d plot.}

\item{whichplots}{Requests plots of the normal mixture density (surface). To get only the 2d plot
set \code{whichplots}=0, only the 3d plot set \code{whichplots}=1,
or for both the 2d and 3d plots set \code{whichplots}=2. Default action is to produce both plots.}

\item{...}{Additional arguments for the S3 method.}
}
\description{
Create a 3d plot and 2d image or contour plots of the
density of a mixture of normal components.

For examples see

\url{http://www.stat.missouri.edu/~amicheas/sppmix/sppmix_all_examples.html
#plot.normmix}
}
\examples{

\dontrun{
# plot normmix density
truemix<- rnormmix(m = 3, sig0 = .1, df = 5, xlim= c(-1, 2), ylim = c(-1, 2))
summary(truemix)
#plot the normal mixture
plot(truemix, xlim= c(-1, 2), ylim = c(-1,2),
 title1="True mixture density in 3d")+add_title(
 "True mixture of normals density")
plot(truemix,xlim= c(-1, 2), ylim = c(-1, 2),contour = TRUE)+add_title(
 "Contour plot of the true mixture of normals density")
#build a mixture intensity surface for the Poisson point process
trueintsurf=to_int_surf(truemix, lambda = 100, win=
 spatstat::owin( c(-1, 2),c(-1, 2)))
plot(trueintsurf)#plot the surface, it is lambda*normmix}

}
\author{
Jiaxun Chen, Sakis Micheas, Yuchen Wang
}
\seealso{
\code{\link{normmix}},
\code{\link{to_int_surf}},
\code{\link[spatstat]{owin}},
\code{\link{rsppmix}}
}

