% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approximations.R
\name{dnormmix}
\alias{dnormmix}
\title{Calculate the density or intensity of a
normal mixture over a fine grid}
\usage{
dnormmix(mix, xlim = c(0, 1), ylim = c(0, 1), L = 128, truncate = TRUE)
}
\arguments{
\item{mix}{An object of class \code{normmix} or \code{intensity_surface}}

\item{xlim, ylim}{Vectors defining the x-y integration limits. A mixture component mass is estimated within
this window.}

\item{L}{Length of the side of the square grid.
The density or intensity is calculated on an L * L grid.
The larger this value is, the slower the calculation,
but the better the approximation.}

\item{truncate}{Requests to truncate the components
of the mixture intensity to have all their mass
within the given x-y limits.}
}
\value{
An object of class \code{\link[spatstat]{im}}. This is a pixel image
 on a grid with values corresponding to the density (or intensity surface) at that location.
}
\description{
When a \code{normmix} object is given, this
function calculates the mixture density over
a fine grid for the given window. When an \code{intensity_surface} object
is given, the function multiplies the density with
 the intensity surface parameter \code{lambda}, and returns the Poisson
 mixture intensity function over the grid. Used for plotting.

For examples see

\url{http://www.stat.missouri.edu/~amicheas/sppmix/sppmix_all_examples.html
#dnormmix}
}
\examples{

\dontrun{
truemix <- rnormmix(m = 3, sig0 = .1, df = 5,xlim= c(0, 5),
 ylim = c(0, 5))
summary(truemix)
normdens=dnormmix(truemix,xlim= c(0, 5), ylim = c(0, 5))
#2d plots
plot_density(as.data.frame(normdens))+ ggplot2::ggtitle(
 "2d mixture density plot\\nWindow=[0,5]x[0,5]")
plot_density(as.data.frame(normdens),TRUE)+ ggplot2::ggtitle(
 "2d mixture contour plot\\nWindow=[0,5]x[0,5]")
#3d plot
plotmix_3d(normdens)
#Now build an intensity surface based on the normal mixture
intsurf=to_int_surf(truemix,lambda = 100, win =
 spatstat::owin( c(0, 5),c(0, 5)))
intsurfdens=dnormmix(intsurf,xlim= c(0, 5), ylim = c(0, 5))
plot_density(as.data.frame(intsurfdens))+ ggplot2::ggtitle(
 "2d mixture intensity plot\\nWindow=[0,5]x[0,5]")
plot_density(as.data.frame(intsurfdens),TRUE)+ ggplot2::ggtitle(
 "2d mixture intensity contour plot\\nWindow=[0,5]x[0,5]")
plotmix_3d(normdens)#3d plot
#For an intensity surface object we use these functions instead
plotmix_2d(intsurf)
plot(intsurf)}

}
\author{
Jiaxun Chen, Sakis Micheas, Yuchen Wang
}
\seealso{
\code{\link{normmix}},
\code{\link{rnormmix}},
\code{\link{plotmix_2d}},
\code{\link{plot_density}},
\code{\link{to_int_surf}}
}

