% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postgen_ops.R
\name{GetStats}
\alias{GetStats}
\title{Retrieves basic Bayesian estimates from a generated chain}
\usage{
GetStats(chain, alpha = 0.05)
}
\arguments{
\item{chain}{A Markov Chain (a vector) containing the posterior realizations of the parameter.}

\item{alpha}{Level to use for the credible set.}
}
\value{
A list containing the min, max, mean, Credible Set and CredibleSetConfidence level.
}
\description{
The function returns the posterior mean and Credible Set
for a parameter based on a chain of posterior realizations.

For examples see

\url{http://www.stat.missouri.edu/~amicheas/sppmix/sppmix_all_examples.html
#GetStats}
}
\examples{

\dontrun{
truemix <- normmix(ps=c(.4, .2,.4), mus=list(c(0.3, 0.3), c(.5,.5),c(0.7, 0.7)),
 sigmas = list(.02*diag(2), .05*diag(2), .01*diag(2)))
intsurf=to_int_surf(truemix,lambda = 100, win = spatstat::square(1))
pp1 <- rsppmix(intsurf)
fit <- est_mix_damcmc(pp1, 3)
p1=GetStats(fit$genps[,1])
p1$Mean
p1$CredibleSet
p2=GetStats(fit$genps[,2])
p2$Mean
p2$CredibleSet
p3=GetStats(fit$genps[,3])
p3$Mean
p3$CredibleSet}

}
\author{
Sakis Micheas
}
\seealso{
\code{\link{normmix}},
\code{\link{to_int_surf}},
\code{\link{rsppmix}},
\code{\link{est_mix_damcmc}}
}

