% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spocc-package.R
\docType{package}
\name{spocc-package}
\alias{spocc-package}
\alias{spocc}
\title{Interface to many species occurrence data sources}
\description{
A programmatic interface to many species occurrence data
sources, including GBIF, USGS's BISON, iNaturalist, Berkeley Ecoinformatics
Engine, eBird, iDigBio, VertNet, OBIS, and ALA. Includes
functionality for retrieving species occurrence data, and
combining that data.
}
\section{Package API}{


The main function to use is \code{\link[=occ]{occ()}} - a single interface to
many species occurrence databases (see below for a list).

Other functions include:
\itemize{
\item \code{\link[=occ2df]{occ2df()}} - Combine results from \code{occ} into a
data.frame
\item \code{\link[=wkt_vis]{wkt_vis()}} - Visualize WKT strings (used to define
geometry based searches for some data sources) in an interactive map
}
}

\section{Currently supported species occurrence data sources}{


\tabular{ll}{
Provider \tab Web \cr
GBIF \tab  \cr
BISON \tab \cr
eBird \tab  \cr
iNaturalist \tab  \cr
VertNet \tab  \cr
iDigBio \tab  \cr
OBIS \tab  \cr
ALA \tab
}
}

\section{Duplicates}{


See \code{\link[=spocc_duplicates]{spocc_duplicates()}} for more.
}

\section{Clean data}{


All data cleaning functionality is in a new package: \code{scrubr}
().
On CRAN: .
See also package
}

\section{Make maps}{


All mapping functionality is now in a separate package: \verb{mapr`` () (formerly known as }spoccutils`).
On CRAN:
}

\author{
Scott Chamberlain
}
\keyword{package}
