% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splot.colorcontrast.R
\name{splot.colorcontrast}
\alias{splot.colorcontrast}
\title{splot color contrast ratio}
\usage{
splot.colorcontrast(color, background = "#ffffff", plot = TRUE)
}
\arguments{
\item{color, background}{A character vector of colors, or a matrix with RGB values across rows.}

\item{plot}{Logical; if \code{FALSE}, will not plot the results.}
}
\value{
A list with entries for \code{ratio} (contrast ratio),
\code{AA} (ratios of at least 4.5), and \code{AAA} (ratios of at least 7).
Each entry contains a matrix with colors in rows and backgrounds in columns.
}
\description{
Calculates the color contrast ratio between two sets of colors, as defined by the
\href{https://www.w3.org/TR/WCAG20/#contrast-ratiodef}{World Wide Web Consortium}.
}
\examples{
# check colors against dark and light backgrounds
splot.colorcontrast(c("#FF0000", "#00FF00", "#0000FF"), c("black", "white"))

# check contrast between colors
splot.colorcontrast(c("red", "green", "blue"), c("red", "green", "blue"))

# see when shades of a color cross thresholds on a given background
splot.colorcontrast(splot.color(1:10, seed = "#a388b5"), "#101010")
}
