% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_aggregations.R
\name{split_coefs}
\alias{split_coefs}
\title{Calculate a bivariate coefficient for each split-half replication}
\usage{
split_coefs(ds, fn_coef, ...)
}
\arguments{
\item{ds}{(data frame) a data frame with columns \code{split}, \code{score_1},
and \code{score_2}}

\item{fn_coef}{(function) a function that calculates a bivariate coefficient.}

\item{...}{Additional arguments passed to \code{fn_coef}}
}
\value{
Coefficients per split calculated via \code{fn_coef}.
}
\description{
Calculates a bivariate coefficient across participants for each split-half
replication and returns their values calculated across
replications. \code{ds} should be a data frame as returned by
\code{\link{by_split}}: For each unique value of the column \code{split} in
\code{ds}, it selects the corresponding rows in \code{ds}, and passes the
values in the columns \code{score_1} and \code{score_2} as the first and
second argument to \code{fn_coef}. Any row in \code{ds} for which
\code{score_1} or \code{score_2} is NA is pairwise removed before passing the
data to \code{fn_coef}. For averaging internal consistency coefficients,
see Feldt and Charter (2006).
}
\section{References}{


 Feldt, L. S., & Charter, R. A. (2006). Averaging internal consistency
 reliability coefficients. \emph{Educational and Psychological Measurement},
 66(2), 215-227.
 \href{https://doi.org/10.1177/0013164404273947}{https://doi.org/10.1177/0013164404273947}
}

\examples{
# Generate five splits with scores that are correlated 0.00, 0.25, 0.5, 0.75, and 1.00
library(MASS)
ds_splits = data.frame(score_1 = numeric(), score_2 = numeric(), replication = numeric())
for (r in 0:4) {
  vars = mvrnorm(10, mu = c(0, 0), Sigma = matrix(c(10, 3, 3, 2), ncol = 2), empirical = FALSE)
  ds_splits = rbind(ds_splits, cbind(vars, r))
}
names(ds_splits) = c("score_1", "score_2", "replication")
# Pearson correlations
split_coefs(ds_splits, cor)
# Spearman-brown corrected Pearson correlations
split_coefs(ds_splits, spearman_brown)
# Flanagan-Rulon coefficient
split_coefs(ds_splits, flanagan_rulon)
# Angoff-Feldt coefficient
split_coefs(ds_splits, angoff_feldt)
# Spearman-Brown corrected ICCs
split_coefs(
  ds_splits,
  spearman_brown,
  short_icc,
  type = "ICC1",
  lmer = FALSE
)
}
\seealso{
Other split aggregation functions: 
\code{\link{split_ci}()}
}
\concept{split aggregation functions}
