% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splithalf.R
\name{splithalf}
\alias{splithalf}
\title{Dot-Probe Split Half}
\usage{
splithalf(data, RTmintrim = "none", RTmaxtrim = "none", incErrors = FALSE,
  conditionlist, halftype, no.iterations = 1, var.RT = "latency",
  var.condition = "blockcode", var.participant = "subject",
  var.correct = "correct", var.trialnum = "trialnum", removelist = "")
}
\arguments{
\item{data}{specifies the raw dataset to be processed}

\item{RTmintrim}{specifies the lower cut-off point for RTs}

\item{RTmaxtrim}{specifies the maximum cut-off point for RTs}

\item{incErrors}{include incorrect trials?, defaults to FALSE}

\item{conditionlist}{sets conditions/blocks to be processed}

\item{halftype}{specifies the split method; "oddeven", "halfs", or "random"}

\item{no.iterations}{specifies the number of random splits to run}

\item{var.RT}{specifies the RT variable name in data}

\item{var.condition}{specifies the condition variable name in data}

\item{var.participant}{specifies the subject variable name in data}

\item{var.correct}{specifies the accuracy variable name in data}

\item{var.trialnum}{specifies the trial number variable}

\item{removelist}{specifies a list of participants to be removed}
}
\value{
Returns a data frame containing split-half reliability estimates for each condition specified.

splithalf returns the raw estimate

spearmanbrown returns the spearman-brown corrected estimate

Warning: If there are missing data (e.g one condition data missing for one participant) output will include details of the missing data and return a dataframe containing the NA data. Warnings will be displayed in the console.
}
\description{
This function calculates split half reliability estimates
}
\examples{
## split half estimates for two blocks of the task
## using 50 iterations of the random split method (note: 5000 would be standard)
splithalf(DPdata, conditionlist = c("block1","block2"), halftype = "random",
no.iterations = 50)
## In datasets with missing data an additional output is generated
## the console will return a list of participants/blocks
## the output will also include a full dataframe of missing values
splithalf(DPdata_missing, conditionlist = c("block1","block2"),
halftype = "random", no.iterations = 50)
}
