% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_partitions.R
\name{generate_partitions}
\alias{generate_partitions}
\title{Generate Splits Partitions Possibilities}
\usage{
generate_partitions(p, G, use.all = TRUE)
}
\arguments{
\item{p}{Number of variables or objects to split.}

\item{G}{Number of groups into which the variables are split.}

\item{use.all}{Boolean variable to determine if all variables must be used (default is TRUE).}
}
\value{
A matrix or list with the number of possible objects in each group using splits.
}
\description{
\code{generate_partitions} returns a matrix with the number of possible objects in each group using splits.
}
\examples{
# Generating the possible split partitions of 6 variables in 3 groups
# Using all the variables
split.3groups.all <- generate_partitions(6, 3)
split.3groups.all
# Without using all the variables
split.3groups <- generate_partitions(6, 3, use.all=FALSE)
split.3groups

}
\author{
Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
