% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splash.R
\name{spin_up}
\alias{spin_up}
\title{Calculate daily totals}
\usage{
spin_up(mdat, dtot)
}
\arguments{
\item{mdat}{list with meteorological data (see the details section).}

\item{dtot}{list with daily totals (see the details section).}
}
\value{
list, daily totals
}
\description{
Calculate daily totals updating the soil moisture until equilibrium.
}
\details{
The list with meteorological data, \code{mdat}, should have the
following components:
\itemize{
\item num_lines ..... double, length of meteorol. variable lists
\item lat_deg ....... double latitude (degrees)
\item elv_m ......... double, elevation (m)
\item year .......... double, year
\item sf ............ list, fraction of sunshine hours
\item tair .......... list, mean daily air temperature (deg. C)
\item pn ............ list, precipitation (mm/d)
}

The list with daily totals, \code{dtot}, should have the following component:
\itemize{
\item wm ............ list, daily soil moisture (mm)
}
}
\examples{
daily_totals <- matrix(data = rep(0, 366), nrow = 366, ncol = 1)
daily_totals <- as.data.frame(daily_totals)
names(daily_totals) <- c("wn")
my_file <- system.file("extdata/example_data.csv", package = "splash")
my_data <- splash::read_csv(my_file, 2000)
my_data$lat_deg <- 37.7
my_data$elv_m <- 142
daily_totals <- splash::spin_up(my_data, daily_totals)
cat(sprintf("Spin-Up:\n"))
for (i in seq(from = 1, to = my_data$num_lines, by = 1)) {
  if (i == 1) cat(sprintf("Day\tWn (mm)\n"))
  cat(sprintf("\%d\t\%0.6f\n", i, daily_totals$wn[i]))
}
}
