% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_manual_tour.r
\name{manual_tour}
\alias{manual_tour}
\title{Produce the series of projection bases to rotate a variable into and out
of a projection.}
\usage{
manual_tour(
  basis,
  manip_var,
  theta = NULL,
  phi_min = 0,
  phi_max = pi/2,
  data = NULL
)
}
\arguments{
\item{basis}{A (p, d) orthonormal numeric matrix.
The linear combination the original variables contribute to projection space.
Defaults to NULL, generating a random basis.}

\item{manip_var}{Integer column number or string exact column name of the.
variable to manipulate. Required, no default.}

\item{theta}{Angle in radians of "in-plane" rotation, on the xy plane of the
reference frame. Defaults to theta of the basis for a radial tour.}

\item{phi_min}{Minimum value phi should move to. Phi is angle in radians of
the "out-of-plane" rotation, the z-axis of the reference frame.
Required, defaults to 0.}

\item{phi_max}{Maximum value phi should move to. Phi is angle in radians of
the "out-of-plane" rotation, the z-axis of the reference frame.
Required, defaults to pi/2.}

\item{data}{Optionally attach data to the basis path.}
}
\value{
A (p, d, 4) history_array of the radial tour. The bases set for
phi_start, \code{phi_min}, \code{phi_max}, and back to phi_start.
}
\description{
Typically called by \code{array2af()}. An array of projections,
the radial tour of the \code{manip_var}, which is rotated from phi's starting
position to \code{phi_max}, to \code{phi_min}, and back to the start position.
}
\examples{
## Setup
dat_std <- scale_sd(wine[, 2:6])
clas <- wine$Type
bas <- basis_pca(dat_std)
mv <- manip_var_of(bas)
manual_tour(basis = bas, manip_var = mv)

## All arguments
manual_tour(basis = bas, manip_var = mv,
            theta = pi / 2, phi_min = pi / 16, phi_max = pi)

## d = 1 case
bas1d <- basis_pca(dat_std, d = 1)
mv <- manip_var_of(bas1d)
manual_tour(basis = bas1d, manip_var = mv)

## Animating with ggtour() & proto_*
mt <- manual_tour(basis = bas, manip_var = mv)
ggt <- ggtour(mt, dat_std, angle = .2) +
    proto_origin() +
    proto_point(list(color = clas, shape = clas)) +
    proto_basis()
\dontrun{
animate_plotly(ggt)}
}
\seealso{
Other manual tour adjacent functions: 
\code{\link{create_manip_space}()},
\code{\link{interpolate_manual_tour}()},
\code{\link{manip_var_of}()},
\code{\link{rotate_manip_space}()}
}
\concept{manual tour adjacent functions}
