% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{view_manip_space}
\alias{view_manip_space}
\title{Plot projection frame and return the axes table.}
\usage{
view_manip_space(
  basis,
  manip_var,
  tilt = 1/12 * pi,
  lab = paste0("V", 1:nrow(basis)),
  manip_col = "blue",
  z_col = "red"
)
}
\arguments{
\item{basis}{A (p, d) orthonormal numeric matrix.
The linear combination the original variables contribute to projection space.
Required, no default.}

\item{manip_var}{Number of the column/dimension to rotate.}

\item{tilt}{angle in radians to rotate the projection plane.
Defaults to pi * 5/12.}

\item{lab}{Optional, character vector of \code{p} length, add name to the axes
in the reference frame, typically the variable names.}

\item{manip_col}{String of the color to highlight the \code{manip_var}.}

\item{z_col}{Color to illustrate the z direction or out of the projection
plane.}
}
\value{
ggplot object of the basis.
}
\description{
Uses base graphics to plot the circle with axes representing
the projection frame. Returns the corresponding table.
}
\examples{
flea_std <- tourr::rescale(tourr::flea[, 1:6])
rb <- tourr::basis_random(ncol(flea_std), 2)

view_manip_space(basis = rb, manip_var = 4)
}
