% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/sph_stat.R
\name{sph_stat_Rayleigh}
\alias{sph_stat_Rayleigh}
\alias{sph_stat_Bingham}
\alias{sph_stat_Ajne}
\alias{sph_stat_Gine_Gn}
\alias{sph_stat_Gine_Fn}
\alias{sph_stat_Pycke}
\alias{sph_stat_Bakshaev}
\alias{sph_stat_Riesz}
\alias{sph_stat_PCvM}
\alias{sph_stat_PRt}
\alias{sph_stat_PAD}
\alias{sph_stat_Poisson}
\alias{sph_stat_Softmax}
\alias{sph_stat_Stereo}
\alias{sph_stat_CCF09}
\alias{sph_stat_Rayleigh_HD}
\alias{sph_stat_CJ12}
\alias{sph_stat}
\title{Statistics for testing (hyper)spherical uniformity}
\usage{
sph_stat_Rayleigh(X)

sph_stat_Bingham(X)

sph_stat_Ajne(X, Psi_in_X = FALSE)

sph_stat_Gine_Gn(X, Psi_in_X = FALSE, p = 0L)

sph_stat_Gine_Fn(X, Psi_in_X = FALSE, p = 0L)

sph_stat_Pycke(X, Psi_in_X = FALSE, p = 0L)

sph_stat_Bakshaev(X, Psi_in_X = FALSE, p = 0L)

sph_stat_Riesz(X, Psi_in_X = FALSE, p = 0L, s = 1)

sph_stat_PCvM(X, Psi_in_X = FALSE, p = 0L, N = 160L, L = 1000L)

sph_stat_PRt(X, Psi_in_X = FALSE, p = 0L, t = 1/3, N = 160L,
  L = 1000L)

sph_stat_PAD(X, Psi_in_X = FALSE, p = 0L, N = 160L, L = 1000L)

sph_stat_Poisson(X, Psi_in_X = FALSE, p = 0L, rho = 0.5)

sph_stat_Softmax(X, Psi_in_X = FALSE, p = 0L, kappa = 1)

sph_stat_Stereo(X, Psi_in_X = FALSE, p = 0L, a = 0)

sph_stat_CCF09(X, dirs, K_CCF09 = 25L, original = FALSE)

sph_stat_Rayleigh_HD(X)

sph_stat_CJ12(X, Psi_in_X = FALSE, p = 0L, regime = 3L)
}
\arguments{
\item{X}{an \bold{array} of size \code{c(n, p, M)} containing the Cartesian
coordinates of \code{M} samples of size \code{n} of directions on
\eqn{S^{p-1}}. Must not contain \code{NA}'s.}

\item{Psi_in_X}{does \code{X} contain the shortest angles matrix
\eqn{\boldsymbol\Psi}{\Psi} that is obtained with \code{\link{Psi_mat}(X)}?
If \code{FALSE} (default), \eqn{\boldsymbol\Psi}{\Psi} is computed
internally.}

\item{p}{integer giving the dimension of the ambient space \eqn{R^p} that
contains \eqn{S^{p-1}}.}

\item{s}{\eqn{s} parameter for the \eqn{s}-Riesz test, a real in
\eqn{(0, 2)}. Defaults to \code{1}.}

\item{N}{number of points used in the
\link[=Gauss_Legen_nodes]{Gauss-Legendre quadrature}. Defaults to
\code{160}.}

\item{L}{number of discretization points to interpolate angular functions
that require evaluating an integral. Defaults to \code{1e3}.}

\item{t}{\eqn{t} parameter for the Rothman and Cressie tests, a real in
\eqn{(0, 1)}. Defaults to \code{1 / 3}.}

\item{rho}{\eqn{\rho} parameter for the Poisson test, a real in
\eqn{[0, 1)}. Defaults to \code{0.5}.}

\item{kappa}{\eqn{\kappa} parameter for the Softmax test, a
non-negative real. Defaults to \code{1}.}

\item{a}{either: \itemize{
\item \eqn{a_n = a / n} parameter used in the length of the arcs
of the coverage-based tests. Must be positive. Defaults to \code{2 * pi}.
\item \eqn{a} parameter for the Stereo test, a real in \eqn{[-1, 1]}.
Defaults to \code{0}.
}}

\item{dirs}{a matrix of size \code{c(n_proj, p)} containing \code{n_proj}
random directions (in Cartesian coordinates) on \eqn{S^{p-1}} to perform
the CCF09 test.}

\item{K_CCF09}{integer giving the truncation of the series present in the
asymptotic distribution of the Kolmogorov-Smirnov statistic. Defaults to
\code{5e2}.}

\item{original}{return the CCF09 statistic as originally defined?
If \code{FALSE} (default), a faster and equivalent statistic is computed,
and rejection happens for \emph{large} values of the statistic, which is
consistent with the rest of tests. Otherwise, rejection happens for
\emph{low} values.}

\item{regime}{type of asymptotic regime for the CJ12 test, either \code{1}
(sub-exponential regime), \code{2} (exponential), or \code{3}
(super-exponential; default).}
}
\value{
A matrix of size \code{c(M, 1)} containing the statistics for each
of the \code{M} samples.
}
\description{
Low-level implementation of several statistics for assessing
uniformity on the (hyper)sphere
\eqn{S^{p-1}:=\{{\bf x}\in R^p:||{\bf x}||=1\}}{S^{p-1}:=
\{x\in R^p:||x||=1\}}, \eqn{p\ge 2}.
}
\details{
Detailed descriptions and references of the statistics are available
in García-Portugués and Verdebout (2018).

The Pycke and CJ12 statistics employ the \emph{scalar products} matrix,
rather than the shortest angles matrix, when \code{Psi_in_X = TRUE}. This
matrix is obtained by setting \code{scalar_prod = TRUE} in
\code{\link{Psi_mat}}.
}
\section{Warning}{

Be careful on avoiding the next bad usages of the functions, which will
produce spurious results:
\itemize{
  \item The directions in \code{X} do \emph{not} have unit norm.
  \item \code{X} does \emph{not} contain \code{Psi_mat(X)} when
  \code{X_in_Theta = TRUE}.
  \item The parameter \code{p} does \emph{not} match with the dimension of
  \eqn{R^p}.
  \item \emph{Not} passing the scalar products matrix to \code{sph_stat_CJ12}
  when \code{Psi_in_X = TRUE}.
  \item The directions in \code{dirs} do \emph{not} have unit norm.
}
}

\examples{
## Sample uniform spherical data

M <- 2
n <- 100
p <- 3
set.seed(123456789)
X <- r_unif_sph(n = n, p = p, M = M)

## Sobolev tests

# Rayleigh
sph_stat_Rayleigh(X)

# Bingham
sph_stat_Bingham(X)

# Ajne
Psi <- Psi_mat(X)
dim(Psi) <- c(dim(Psi), 1)
sph_stat_Ajne(X)
sph_stat_Ajne(Psi, Psi_in_X = TRUE)

# Gine Gn
sph_stat_Gine_Gn(X)
sph_stat_Gine_Gn(Psi, Psi_in_X = TRUE, p = p)

# Gine Fn
sph_stat_Gine_Fn(X)
sph_stat_Gine_Fn(Psi, Psi_in_X = TRUE, p = p)

# Pycke
sph_stat_Pycke(X)
sph_stat_Pycke(Psi, Psi_in_X = TRUE, p = p)

# Bakshaev
sph_stat_Bakshaev(X)
sph_stat_Bakshaev(Psi, Psi_in_X = TRUE, p = p)

# Riesz
sph_stat_Riesz(X, s = 1)
sph_stat_Riesz(Psi, Psi_in_X = TRUE, p = p, s = 1)

# Projected Cramér-von Mises
sph_stat_PCvM(X)
sph_stat_PCvM(Psi, Psi_in_X = TRUE, p = p)

# Projected Rothman
sph_stat_PRt(X)
sph_stat_PRt(Psi, Psi_in_X = TRUE, p = p)

# Projected Anderson-Darling
sph_stat_PAD(X)
sph_stat_PAD(Psi, Psi_in_X = TRUE, p = p)

## Other tests

# CCF09
dirs <- r_unif_sph(n = 3, p = p, M = 1)[, , 1]
sph_stat_CCF09(X, dirs = dirs)

## High-dimensional tests

# Rayleigh HD-Standardized
sph_stat_Rayleigh_HD(X)

# CJ12
sph_stat_CJ12(X, regime = 1)
sph_stat_CJ12(Psi, regime = 1, Psi_in_X = TRUE, p = p)
sph_stat_CJ12(X, regime = 2)
sph_stat_CJ12(Psi, regime = 2, Psi_in_X = TRUE, p = p)
sph_stat_CJ12(X, regime = 3)
sph_stat_CJ12(Psi, regime = 3, Psi_in_X = TRUE, p = p)
}
\references{
García-Portugués, E. and Verdebout, T. (2018) An overview of uniformity
tests on the hypersphere. \emph{arXiv:1804.00286}.
\url{https://arxiv.org/abs/1804.00286}.
}
