% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/distr.R
\name{proj_unif}
\alias{proj_unif}
\alias{d_proj_unif}
\alias{p_proj_unif}
\alias{q_proj_unif}
\alias{r_proj_unif}
\title{Projection of the spherical uniform distribution}
\usage{
d_proj_unif(x, p, log = FALSE)

p_proj_unif(x, p, log = FALSE)

q_proj_unif(u, p)

r_proj_unif(n, p)
}
\arguments{
\item{x}{a vector of size \code{nx} or a matrix of size \code{c(nx, 1)}.}

\item{p}{integer giving the dimension of the ambient space \eqn{R^p} that
contains \eqn{S^{p-1}}.}

\item{log}{compute the logarithm of the density or distribution?}

\item{u}{vector of probabilities.}

\item{n}{sample size employed for computing the statistic.}
}
\value{
A matrix of size \code{c(nx, 1)} with the evaluation of the
density, distribution, or quantile function at \code{x} or \code{u}.
For \code{r_proj_unif}, a random vector of size \code{n}.
}
\description{
Density, distribution, and quantile functions of the
projection of the spherical uniform random variable on an arbitrary
direction, that is, the random variable
\eqn{\boldsymbol{\gamma}'{\bf X}}{\gamma'X}, where \eqn{{\bf X}}{X}
is uniformly distributed on the (hyper)sphere
\eqn{S^{p-1}:=\{{\bf x}\in R^p:||{\bf x}||=1\}}{S^{p-1}:=
\{x\in R^p:||x||=1\}}, \eqn{p\ge 2}, and
\eqn{\boldsymbol{\gamma}\in S^{p-1}}{\gamma\in S^{p-1}} is an
\emph{arbitrary} projection direction. Note that the distribution is
invariant to the choice of \eqn{\boldsymbol{\gamma}}{\gamma}. Also,
efficient simulation of \eqn{\boldsymbol{\gamma}'{\bf X}}{\gamma'X}.
}
\examples{
# Density function
curve(d_proj_unif(x, p = 2), from = -2, to = 2, n = 2e2, ylim = c(0, 2))
curve(d_proj_unif(x, p = 3), n = 2e2, col = 2, add = TRUE)
curve(d_proj_unif(x, p = 4), n = 2e2, col = 3, add = TRUE)
curve(d_proj_unif(x, p = 5), n = 2e2, col = 4, add = TRUE)
curve(d_proj_unif(x, p = 6), n = 2e2, col = 5, add = TRUE)

# Distribution function
curve(p_proj_unif(x, p = 2), from = -2, to = 2, n = 2e2, ylim = c(0, 1))
curve(p_proj_unif(x, p = 3), n = 2e2, col = 2, add = TRUE)
curve(p_proj_unif(x, p = 4), n = 2e2, col = 3, add = TRUE)
curve(p_proj_unif(x, p = 5), n = 2e2, col = 4, add = TRUE)
curve(p_proj_unif(x, p = 6), n = 2e2, col = 5, add = TRUE)

# Quantile function
curve(q_proj_unif(u = x, p = 2), from = 0, to = 1, n = 2e2, ylim = c(-1, 1))
curve(q_proj_unif(u = x, p = 3), n = 2e2, col = 2, add = TRUE)
curve(q_proj_unif(u = x, p = 4), n = 2e2, col = 3, add = TRUE)
curve(q_proj_unif(u = x, p = 5), n = 2e2, col = 4, add = TRUE)
curve(q_proj_unif(u = x, p = 6), n = 2e2, col = 5, add = TRUE)

# Sampling
hist(r_proj_unif(n = 1e4, p = 4), freq = FALSE, breaks = 50)
curve(d_proj_unif(x, p = 4), n = 2e2, col = 3, add = TRUE)
}
\author{
Eduardo García-Portugués and Paula Navarro-Esteban.
}
