/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class OdfXMLHelper {
    public XMLReader newXMLReader(OdfPackage pkg) throws SAXException, ParserConfigurationException {
        SAXParserFactoryImpl factory = new SAXParserFactoryImpl();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        XMLReader xmlReader = parser.getXMLReader();
        xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
        xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        xmlReader.setFeature("http://xml.org/sax/features/xmlns-uris", true);
        xmlReader.setEntityResolver(pkg.getEntityResolver());
        return xmlReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(OdfPackage pkg, String path, ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException, ParserConfigurationException, IOException, IllegalArgumentException, TransformerConfigurationException, TransformerException {
        InputStream is = null;
        try {
            is = pkg.getInputStream(path);
            XMLReader reader = this.newXMLReader(pkg);
            String uri = pkg.getBaseURI() + path;
            if (contentHandler != null) {
                reader.setContentHandler(contentHandler);
            }
            if (errorHandler != null) {
                reader.setErrorHandler(errorHandler);
            }
            InputSource ins = new InputSource(is);
            ins.setSystemId(uri);
            reader.parse(ins);
        }
        catch (Exception ex) {
            Logger.getLogger(OdfXMLHelper.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {
                Logger.getLogger(OdfXMLHelper.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void transform(OdfPackage pkg, String path, String templatePath, String outPath) throws TransformerConfigurationException, TransformerException, IOException, IllegalArgumentException, SAXException, ParserConfigurationException {
        this.transform(pkg, path, new File(templatePath), new File(outPath));
    }

    public void transform(OdfPackage pkg, String path, Source templateSource, String outPath) throws TransformerConfigurationException, TransformerException, IOException, IllegalArgumentException, SAXException, ParserConfigurationException {
        this.transform(pkg, path, templateSource, new File(outPath));
    }

    public void transform(OdfPackage pkg, String path, Source templateSource, File out) throws TransformerConfigurationException, TransformerException, IOException, IllegalArgumentException, SAXException, ParserConfigurationException {
        this.transform(pkg, path, templateSource, (Result)new StreamResult(out));
    }

    public void transform(OdfPackage pkg, String path, String templatePath) throws TransformerConfigurationException, TransformerException, IOException, IllegalArgumentException, SAXException, ParserConfigurationException {
        this.transform(pkg, path, new File(templatePath));
    }

    public void transform(OdfPackage pkg, String path, File template, File out) throws TransformerConfigurationException, TransformerException, IOException, IllegalArgumentException, SAXException, ParserConfigurationException {
        TransformerFactory transformerfactory = TransformerFactory.newInstance();
        Templates templates = transformerfactory.newTemplates(new StreamSource(template));
        this.transform(pkg, path, templates, (Result)new StreamResult(out));
    }

    public void transform(OdfPackage pkg, String path, File template) throws TransformerConfigurationException, TransformerException, IOException, IllegalArgumentException, SAXException, ParserConfigurationException {
        TransformerFactory transformerfactory = TransformerFactory.newInstance();
        Templates templates = transformerfactory.newTemplates(new StreamSource(template));
        this.transform(pkg, path, templates);
    }

    public void transform(OdfPackage pkg, String path, Source templateSource, Result result) throws TransformerConfigurationException, TransformerException, IOException, IllegalArgumentException, SAXException, ParserConfigurationException {
        TransformerFactory transformerfactory = TransformerFactory.newInstance();
        transformerfactory.setURIResolver(pkg.getURIResolver());
        Templates templates = transformerfactory.newTemplates(templateSource);
        this.transform(pkg, path, templates, result);
    }

    public void transform(OdfPackage pkg, String path, Templates templates, Result result) throws TransformerConfigurationException, TransformerException, IOException, IllegalArgumentException, SAXException, ParserConfigurationException {
        try {
            DocumentType doctype;
            DOMSource source = null;
            String uri = pkg.getBaseURI() + path;
            Document doc = pkg.getDom(path);
            source = new DOMSource(doc);
            Transformer transformer = templates.newTransformer();
            transformer.setURIResolver(pkg.getURIResolver());
            transformer.setParameter("sourceURL", uri);
            transformer.setParameter("sourceBaseURL", pkg.getBaseURI() + "/");
            uri = result.getSystemId();
            if (uri != null) {
                transformer.setParameter("targetURL", uri);
                int i = uri.lastIndexOf(47);
                if (i > 0) {
                    uri = uri.substring(0, i + 1);
                    transformer.setParameter("targetBaseURL", uri);
                }
            }
            if ((doctype = doc.getDoctype()) != null) {
                if (doctype.getPublicId() != null) {
                    transformer.setParameter("publicType", doctype.getPublicId());
                }
                if (doctype.getSystemId() != null) {
                    transformer.setParameter("systemType", doctype.getSystemId());
                }
            }
            transformer.transform(source, result);
        }
        catch (Exception ex) {
            Logger.getLogger(OdfXMLHelper.class.getName()).log(Level.SEVERE, null, ex);
            ex.printStackTrace();
        }
    }

    public void transform(OdfPackage pkg, String path, Templates templates) throws TransformerConfigurationException, TransformerException, IOException, IllegalArgumentException, SAXException, ParserConfigurationException {
        Result result = null;
        ByteArrayOutputStream baos = null;
        if (pkg.hasDom(path)) {
            result = new DOMResult();
        } else {
            baos = new ByteArrayOutputStream();
            result = new StreamResult(baos);
        }
        this.transform(pkg, path, templates, result);
        if (pkg.hasDom(path)) {
            try {
                pkg.insert((Document)((DOMResult)result).getNode(), path, null);
            }
            catch (Exception ex) {
                Logger.getLogger(OdfXMLHelper.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            try {
                byte[] data = baos.toByteArray();
                pkg.insert(data, path, "text/xml");
            }
            catch (Exception ex) {
                Logger.getLogger(OdfXMLHelper.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

