/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.relocator;

import bibliothek.gui.DockStation;
import bibliothek.gui.dock.control.relocator.Merger;
import java.util.ArrayList;
import java.util.List;

public class MultiMerger
implements Merger {
    private List<Merger> mergers = new ArrayList<Merger>();

    public void add(Merger merger) {
        if (merger == null) {
            throw new IllegalArgumentException("merger must not be null");
        }
        this.mergers.add(merger);
    }

    public void remove(Merger merger) {
        this.mergers.remove(merger);
    }

    public int size() {
        return this.mergers.size();
    }

    public Merger get(int index) {
        return this.mergers.get(index);
    }

    public boolean canMerge(DockStation parent, DockStation child) {
        for (Merger merger : this.mergers) {
            if (!merger.canMerge(parent, child)) continue;
            return true;
        }
        return false;
    }

    public void merge(DockStation parent, DockStation child) {
        for (Merger merger : this.mergers) {
            if (!merger.canMerge(parent, child)) continue;
            merger.merge(parent, child);
            return;
        }
    }
}

