/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference.editor;

import bibliothek.extension.gui.dock.preference.PreferenceEditor;
import bibliothek.extension.gui.dock.preference.PreferenceEditorCallback;
import bibliothek.extension.gui.dock.preference.PreferenceEditorFactory;
import bibliothek.extension.gui.dock.preference.PreferenceOperation;
import java.awt.Component;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringEditor
extends JTextField
implements PreferenceEditor<String> {
    public static final PreferenceEditorFactory<String> FACTORY = new PreferenceEditorFactory<String>(){

        @Override
        public PreferenceEditor<String> create() {
            return new StringEditor();
        }
    };
    private PreferenceEditorCallback<String> callback;
    private boolean onUpdate = false;

    public StringEditor() {
        this.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                StringEditor.this.update(true);
            }

            public void insertUpdate(DocumentEvent e) {
                StringEditor.this.update(true);
            }

            public void removeUpdate(DocumentEvent e) {
                StringEditor.this.update(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(boolean transmit) {
        try {
            this.onUpdate = true;
            if (this.callback != null) {
                this.callback.setOperation(PreferenceOperation.DELETE, this.getText().length() > 0);
                if (transmit) {
                    this.callback.set(this.getText());
                }
            }
        }
        finally {
            this.onUpdate = false;
        }
    }

    @Override
    public void doOperation(PreferenceOperation operation) {
        if (operation == PreferenceOperation.DELETE) {
            this.setText("");
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public String getValue() {
        return this.getText();
    }

    @Override
    public void setCallback(PreferenceEditorCallback<String> callback) {
        this.callback = callback;
        this.update(false);
    }

    @Override
    public void setValue(String value) {
        if (!this.onUpdate) {
            this.setText(value == null ? "" : value);
            this.update(false);
        }
    }

    @Override
    public void setValueInfo(Object information) {
    }
}

