/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.dockable.ScreencaptureMovingImageFactory;
import bibliothek.gui.dock.focus.DefaultDockableSelection;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class BasicDockableSelection
extends DefaultDockableSelection {
    private ImagePainter painter;

    public BasicDockableSelection() {
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.painter = new ImagePainter(new Dimension(300, 200));
        this.removeAll();
        this.setLayout(new GridBagLayout());
        this.add((Component)this.painter, new GridBagConstraints(0, 0, 1, 1, 2.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getList(), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.revalidate();
    }

    protected void setSelection(Dockable dockable) {
        super.setSelection(dockable);
        this.painter.paint(dockable);
    }

    public void updateUI() {
        super.updateUI();
        if (this.painter != null) {
            this.painter.updateUI();
        }
    }

    private class ImagePainter
    extends JComponent {
        private BufferedImage image;
        private ScreencaptureMovingImageFactory factory;

        public ImagePainter(Dimension size) {
            this.factory = new ScreencaptureMovingImageFactory(size);
            this.setPreferredSize(new Dimension(size.width + 4, size.height + 4));
        }

        private void paint(Dockable dockable) {
            this.image = dockable == null ? null : this.factory.createImageFrom(BasicDockableSelection.this.getController(), dockable);
            this.repaint();
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.image != null) {
                int x = (this.getWidth() - this.image.getWidth()) / 2;
                int y = (this.getHeight() - this.image.getHeight()) / 2;
                g.drawImage(this.image, x, y, this);
                g.setColor(this.getForeground());
                g.drawRect(x - 1, y - 1, this.image.getWidth(), this.image.getHeight());
            }
        }
    }
}

