/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.buttons;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.actions.SimpleMenuAction;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.DockActionSourceListener;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.IconManagerListener;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Color;
import java.awt.Component;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ButtonPanel
extends JPanel {
    private DockTitle.Orientation orientation = DockTitle.Orientation.FREE_HORIZONTAL;
    private Dockable dockable;
    private DockActionSource source;
    private Listener listener = new Listener();
    private List<ActionItem> actions = new ArrayList<ActionItem>();
    private DefaultDockActionSource menuSource;
    private BasicTitleViewItem<JComponent> menuItem;
    private SimpleMenuAction menuAction;
    private int visibleActions = -1;

    public ButtonPanel(boolean bl) {
        this.setLayout(null);
        this.setOpaque(false);
        if (bl) {
            this.menuSource = new DefaultDockActionSource(new DockAction[0]);
            this.menuAction = new SimpleMenuAction(this.menuSource);
        }
        this.setFocusable(false);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new ContainerOrderFocusTraversalPolicy());
    }

    protected BasicTitleViewItem<JComponent> createItemFor(DockAction dockAction, Dockable dockable) {
        return dockable.getController().getActionViewConverter().createView(dockAction, ViewTarget.TITLE, dockable);
    }

    public int getItemCount() {
        int n = 0;
        for (ActionItem actionItem : this.actions) {
            if (actionItem.item == null) continue;
            ++n;
        }
        return n;
    }

    public void setOrientation(DockTitle.Orientation orientation) {
        if (this.orientation != orientation) {
            this.orientation = orientation;
            if (this.menuItem != null) {
                this.menuItem.setOrientation(orientation);
            }
            for (ActionItem actionItem : this.actions) {
                if (actionItem.item == null) continue;
                actionItem.item.setOrientation(orientation);
            }
            this.revalidate();
        }
    }

    public DockTitle.Orientation getOrientation() {
        return this.orientation;
    }

    public void set(Dockable dockable) {
        if (dockable == null) {
            this.set(null, null);
        } else {
            this.set(dockable, dockable.getGlobalActionOffers());
        }
    }

    public void set(Dockable dockable, DockActionSource dockActionSource) {
        this.set(dockable, dockActionSource, false);
    }

    private void set() {
        this.set(this.dockable, this.source, true);
    }

    public void set(Dockable dockable, DockActionSource dockActionSource, boolean bl) {
        if (dockActionSource == null != (dockable == null)) {
            throw new IllegalArgumentException("Either both arguments are null, or none");
        }
        if (bl || this.source != dockActionSource || this.dockable != dockable) {
            if (this.source != null) {
                this.removeAll();
                for (ActionItem object : this.actions) {
                    if (object.item == null) continue;
                    object.item.unbind();
                    object.action.unbind(this.dockable);
                }
                if (this.menuAction != null) {
                    if (this.menuItem != null) {
                        this.menuItem.unbind();
                        this.menuItem = null;
                    }
                    this.menuAction.unbind(this.dockable);
                    this.menuSource.removeAll();
                }
                this.actions.clear();
                this.source.removeDockActionSourceListener(this.listener);
            }
            this.source = dockActionSource;
            this.dockable = dockable;
            this.listener.setDockable(dockable);
            if (dockActionSource != null) {
                if (this.menuAction != null) {
                    this.menuAction.bind(dockable);
                    if (dockable.getController() != null) {
                        this.menuItem = this.createItemFor(this.menuAction, dockable);
                        if (this.menuItem != null) {
                            this.menuItem.setOrientation(this.orientation);
                            this.menuItem.setForeground(this.getForeground());
                            this.menuItem.setBackground(this.getBackground());
                            this.menuItem.bind();
                        }
                    }
                }
                dockActionSource.addDockActionSourceListener(this.listener);
                for (DockAction dockAction : dockActionSource) {
                    BasicTitleViewItem<JComponent> basicTitleViewItem;
                    ActionItem actionItem = new ActionItem();
                    actionItem.action = dockAction;
                    this.actions.add(actionItem);
                    if (dockable.getController() == null || (basicTitleViewItem = this.createItemFor(dockAction, dockable)) == null) continue;
                    dockAction.bind(dockable);
                    basicTitleViewItem.bind();
                    actionItem.item = basicTitleViewItem;
                    basicTitleViewItem.setOrientation(this.orientation);
                    basicTitleViewItem.setForeground(this.getForeground());
                    basicTitleViewItem.setBackground(this.getBackground());
                }
            }
            this.visibleActions = this.actions.size();
            this.resetVisibleActions();
            this.revalidate();
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.menuItem != null) {
            this.menuItem.setForeground(color);
        }
        if (this.actions != null) {
            for (ActionItem actionItem : this.actions) {
                if (actionItem.item == null) continue;
                actionItem.item.setForeground(color);
            }
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.menuItem != null) {
            this.menuItem.setBackground(color);
        }
        if (this.actions != null) {
            for (ActionItem actionItem : this.actions) {
                if (actionItem.item == null) continue;
                actionItem.item.setBackground(color);
            }
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ButtonPanel.this.setForeground(ButtonPanel.this.getForeground());
                ButtonPanel.this.setBackground(ButtonPanel.this.getBackground());
            }
        });
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.actions.isEmpty()) {
            return new Dimension(0, 0);
        }
        if (this.menuItem == null) {
            return this.getPreferredSize();
        }
        return ((JComponent)this.menuItem.getItem()).getMinimumSize();
    }

    public Dimension[] getPreferredSizes() {
        if (this.actions.isEmpty()) {
            return new Dimension[]{new Dimension(0, 0)};
        }
        if (this.menuAction == null) {
            return new Dimension[]{this.getPreferredSize()};
        }
        Dimension dimension = new Dimension(0, 0);
        Dimension dimension2 = this.menuItem == null ? new Dimension(0, 0) : ((JComponent)this.menuItem.getItem()).getPreferredSize();
        Dimension[] dimensionArray = new Dimension[this.actions.size() + 1];
        dimensionArray[0] = new Dimension(dimension2);
        int n = this.actions.size();
        for (int i = 0; i < n; ++i) {
            Dimension dimension3;
            BasicTitleViewItem<JComponent> basicTitleViewItem = this.actions.get((int)i).item;
            if (basicTitleViewItem != null) {
                dimension3 = ((JComponent)basicTitleViewItem.getItem()).getPreferredSize();
                if (this.orientation.isHorizontal()) {
                    dimension.width += dimension3.width;
                    dimension.height = Math.max(dimension.height, dimension3.height);
                } else {
                    dimension.width = Math.max(dimension.width, dimension3.width);
                    dimension.height += dimension3.height;
                }
            }
            dimension3 = new Dimension(dimension);
            if (i + 1 < n) {
                if (this.orientation.isHorizontal()) {
                    dimension3.width += dimension2.width;
                    dimension3.height = Math.max(dimension3.height, dimension2.height);
                } else {
                    dimension3.width = Math.max(dimension3.width, dimension2.width);
                    dimension3.height += dimension2.height;
                }
            }
            dimensionArray[i + 1] = dimension3;
        }
        Insets insets = this.getInsets();
        for (Dimension dimension4 : dimensionArray) {
            dimension4.width += insets.left + insets.right;
            dimension4.height += insets.top + insets.bottom;
        }
        return dimensionArray;
    }

    public Dimension getCurrentPreferredSize() {
        int n;
        int n2 = 0;
        int n3 = 0;
        if (this.orientation.isHorizontal()) {
            int n4 = this.getComponentCount();
            for (n = 0; n < n4; ++n) {
                Dimension dimension = this.getComponent(n).getPreferredSize();
                n2 += dimension.width;
                n3 = Math.max(n3, dimension.height);
            }
        } else {
            int n5 = this.getComponentCount();
            for (n = 0; n < n5; ++n) {
                Dimension dimension = this.getComponent(n).getPreferredSize();
                n2 = Math.max(n2, dimension.width);
                n3 += dimension.height;
            }
        }
        Insets insets = this.getInsets();
        return new Dimension(n2 + insets.left + insets.right, n3 + insets.top + insets.bottom);
    }

    @Override
    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        if (this.orientation.isHorizontal()) {
            for (ActionItem actionItem : this.actions) {
                if (actionItem.item == null) continue;
                Dimension dimension = ((JComponent)actionItem.item.getItem()).getPreferredSize();
                n += dimension.width;
                n2 = Math.max(n2, dimension.height);
            }
        } else {
            for (ActionItem actionItem : this.actions) {
                if (actionItem.item == null) continue;
                Dimension dimension = ((JComponent)actionItem.item.getItem()).getPreferredSize();
                n = Math.max(n, dimension.width);
                n2 += dimension.height;
            }
        }
        Insets insets = this.getInsets();
        return new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
    }

    public void setVisibleActions(int n) {
        if (this.visibleActions != n) {
            this.visibleActions = n;
            this.resetVisibleActions();
        }
    }

    private void resetVisibleActions() {
        this.removeAll();
        if (this.menuItem == null) {
            for (ActionItem actionItem : this.actions) {
                if (actionItem.item == null) continue;
                this.add((Component)actionItem.item.getItem());
            }
        } else {
            this.menuSource.removeAll();
            int n = 0;
            int n2 = 0;
            int n3 = this.actions.size();
            int n4 = this.actions.size();
            while (n < this.visibleActions && n2 < n4) {
                BasicTitleViewItem<JComponent> basicTitleViewItem = this.actions.get((int)n2++).item;
                if (basicTitleViewItem == null) {
                    --n3;
                    continue;
                }
                ++n;
                this.add((Component)basicTitleViewItem.getItem());
            }
            if (n < n3) {
                int n5 = this.actions.size();
                for (int i = n; i < n5; ++i) {
                    this.menuSource.add(this.actions.get((int)i).action);
                }
                this.add((Component)this.menuItem.getItem());
            }
        }
    }

    @Override
    public void doLayout() {
        Dimension dimension = this.getCurrentPreferredSize();
        Insets insets = this.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        if (this.orientation.isHorizontal()) {
            if (dimension.width <= 0) {
                return;
            }
            int n = insets.left;
            int n2 = insets.top;
            int n3 = this.getHeight() - insets.left - insets.right;
            int n4 = this.getWidth() - insets.top - insets.bottom;
            if (n4 > dimension.width) {
                n += n4 - dimension.width;
                n4 = dimension.width;
            }
            int n5 = this.getComponentCount();
            for (int i = 0; i < n5; ++i) {
                Component component = this.getComponent(i);
                Dimension dimension2 = component.getPreferredSize();
                if (dimension.width <= 0) {
                    if (n4 <= 0) {
                        n4 = 1;
                    }
                    dimension.width = n4;
                }
                if (n4 == dimension.width) {
                    component.setBounds(n, n2, dimension2.width, n3);
                } else {
                    double d = (double)n4 / (double)dimension.width;
                    component.setBounds(n, n2, (int)(d * (double)dimension2.width), n3);
                }
                dimension.width -= dimension2.width;
                n4 -= component.getWidth();
                n += component.getWidth();
            }
        } else {
            if (dimension.width <= 0) {
                return;
            }
            int n = insets.left;
            int n6 = insets.top;
            int n7 = this.getHeight() - insets.top - insets.bottom;
            int n8 = this.getWidth() - insets.left - insets.bottom;
            if (n7 > dimension.height) {
                n6 += n7 - dimension.height;
                n7 = dimension.height;
            }
            int n9 = this.getComponentCount();
            for (int i = 0; i < n9; ++i) {
                Component component = this.getComponent(i);
                Dimension dimension3 = component.getPreferredSize();
                if (dimension.height <= 0) {
                    if (n7 <= 0) {
                        n7 = 1;
                    }
                    dimension.height = n7;
                }
                if (n7 == dimension.height) {
                    component.setBounds(n, n6, n8, dimension3.height);
                } else {
                    double d = (double)n7 / (double)dimension.height;
                    component.setBounds(n, n6, n8, (int)(d * (double)dimension3.height));
                }
                dimension.height -= dimension3.height;
                n7 -= component.getHeight();
                n6 += component.getHeight();
            }
        }
    }

    private class Listener
    implements DockActionSourceListener,
    IconManagerListener,
    DockHierarchyListener {
        private Dockable dockable;
        private DockController controller;

        private Listener() {
        }

        public void setDockable(Dockable dockable) {
            if (this.dockable != null) {
                this.dockable.removeDockHierarchyListener(this);
                this.dockable = null;
            }
            if (this.controller != null) {
                if (ButtonPanel.this.menuAction != null) {
                    this.controller.getIcons().remove("overflow.menu", this);
                }
                this.controller = null;
            }
            this.dockable = dockable;
            if (dockable != null) {
                dockable.addDockHierarchyListener(this);
                this.controller = dockable.getController();
            }
            if (ButtonPanel.this.menuAction != null) {
                if (this.controller != null) {
                    this.controller.getIcons().add("overflow.menu", this);
                    this.iconChanged("overflow.menu", this.controller.getIcons().getIcon("overflow.menu"));
                } else {
                    this.iconChanged("overflow.menu", null);
                }
            }
        }

        public void iconChanged(String string, Icon icon) {
            if (ButtonPanel.this.menuAction != null) {
                ButtonPanel.this.menuAction.setIcon(icon);
            }
        }

        public void controllerChanged(DockHierarchyEvent dockHierarchyEvent) {
            if (this.controller != null) {
                if (ButtonPanel.this.menuAction != null) {
                    this.controller.getIcons().remove("overflow.menu", this);
                }
                this.controller = null;
            }
            if (this.dockable != null) {
                this.controller = this.dockable.getController();
            }
            if (ButtonPanel.this.menuAction != null) {
                if (this.controller != null) {
                    this.controller.getIcons().add("overflow.menu", this);
                    this.iconChanged("overflow.menu", this.controller.getIcons().getIcon("overflow.menu"));
                } else {
                    this.iconChanged("overflow.menu", null);
                }
            }
            ButtonPanel.this.set();
        }

        public void hierarchyChanged(DockHierarchyEvent dockHierarchyEvent) {
        }

        public void actionsAdded(DockActionSource dockActionSource, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                DockAction dockAction = dockActionSource.getDockAction(i);
                ActionItem actionItem = new ActionItem();
                actionItem.action = dockAction;
                if (this.dockable.getController() != null) {
                    BasicTitleViewItem<JComponent> basicTitleViewItem = ButtonPanel.this.createItemFor(dockAction, this.dockable);
                    actionItem.item = basicTitleViewItem;
                    if (basicTitleViewItem != null) {
                        dockAction.bind(this.dockable);
                        basicTitleViewItem.bind();
                        basicTitleViewItem.setOrientation(ButtonPanel.this.orientation);
                        basicTitleViewItem.setForeground(ButtonPanel.this.getForeground());
                        basicTitleViewItem.setBackground(ButtonPanel.this.getBackground());
                    }
                }
                ButtonPanel.this.actions.add(i, actionItem);
            }
            ButtonPanel.this.visibleActions = ButtonPanel.this.actions.size();
            ButtonPanel.this.resetVisibleActions();
            ButtonPanel.this.revalidate();
        }

        public void actionsRemoved(DockActionSource dockActionSource, int n, int n2) {
            for (int i = n2; i >= n; --i) {
                ActionItem actionItem = (ActionItem)ButtonPanel.this.actions.remove(i);
                if (actionItem.item == null) continue;
                actionItem.item.unbind();
                actionItem.action.unbind(this.dockable);
            }
            ButtonPanel.this.visibleActions = ButtonPanel.this.actions.size();
            ButtonPanel.this.resetVisibleActions();
            ButtonPanel.this.revalidate();
        }
    }

    private static class ActionItem {
        public DockAction action;
        public BasicTitleViewItem<JComponent> item;

        private ActionItem() {
        }
    }
}

