/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.view;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionType;
import bibliothek.gui.dock.action.ButtonDockAction;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DropDownAction;
import bibliothek.gui.dock.action.MenuDockAction;
import bibliothek.gui.dock.action.SelectableDockAction;
import bibliothek.gui.dock.action.actions.SeparatorAction;
import bibliothek.gui.dock.action.view.ViewGenerator;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.themes.basic.action.BasicButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicMenuHandler;
import bibliothek.gui.dock.themes.basic.action.BasicSelectableHandler;
import bibliothek.gui.dock.themes.basic.action.BasicSeparatorHandler;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.basic.action.buttons.BasicMiniButton;
import bibliothek.gui.dock.themes.basic.action.buttons.DropDownMiniButton;
import bibliothek.gui.dock.themes.basic.action.dropdown.ButtonDropDownHandler;
import bibliothek.gui.dock.themes.basic.action.dropdown.DropDownViewItem;
import bibliothek.gui.dock.themes.basic.action.dropdown.SelectableDropDownHandler;
import bibliothek.gui.dock.themes.basic.action.dropdown.SubDropDownHandler;
import bibliothek.gui.dock.themes.basic.action.menu.ButtonMenuHandler;
import bibliothek.gui.dock.themes.basic.action.menu.DropDownMenuHandler;
import bibliothek.gui.dock.themes.basic.action.menu.MenuMenuHandler;
import bibliothek.gui.dock.themes.basic.action.menu.MenuViewItem;
import bibliothek.gui.dock.themes.basic.action.menu.SelectableMenuHandler;
import bibliothek.util.container.Tuple;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionViewConverter {
    private Map<Tuple<ActionType<?>, ViewTarget<?>>, Entry<?, ?>> converters = new HashMap();

    public ActionViewConverter() {
        this.putDefault(ActionType.BUTTON, ViewTarget.MENU, new ViewGenerator<ButtonDockAction, MenuViewItem<JComponent>>(){

            @Override
            public MenuViewItem<JComponent> create(ActionViewConverter actionViewConverter, ButtonDockAction buttonDockAction, Dockable dockable) {
                return new ButtonMenuHandler(buttonDockAction, dockable);
            }
        });
        this.putDefault(ActionType.CHECK, ViewTarget.MENU, new ViewGenerator<SelectableDockAction, MenuViewItem<JComponent>>(){

            @Override
            public MenuViewItem<JComponent> create(ActionViewConverter actionViewConverter, SelectableDockAction selectableDockAction, Dockable dockable) {
                return new SelectableMenuHandler(selectableDockAction, dockable, new JCheckBoxMenuItem());
            }
        });
        this.putDefault(ActionType.MENU, ViewTarget.MENU, new ViewGenerator<MenuDockAction, MenuViewItem<JComponent>>(){

            @Override
            public MenuViewItem<JComponent> create(ActionViewConverter actionViewConverter, MenuDockAction menuDockAction, Dockable dockable) {
                return new MenuMenuHandler(menuDockAction, dockable);
            }
        });
        this.putDefault(ActionType.RADIO, ViewTarget.MENU, new ViewGenerator<SelectableDockAction, MenuViewItem<JComponent>>(){

            @Override
            public MenuViewItem<JComponent> create(ActionViewConverter actionViewConverter, SelectableDockAction selectableDockAction, Dockable dockable) {
                return new SelectableMenuHandler(selectableDockAction, dockable, new JRadioButtonMenuItem());
            }
        });
        this.putDefault(ActionType.SEPARATOR, ViewTarget.MENU, new ViewGenerator<SeparatorAction, MenuViewItem<JComponent>>(){

            @Override
            public MenuViewItem<JComponent> create(ActionViewConverter actionViewConverter, SeparatorAction separatorAction, Dockable dockable) {
                if (separatorAction.shouldDisplay(ViewTarget.MENU)) {
                    return new BasicSeparatorHandler(new JPopupMenu.Separator(), separatorAction);
                }
                return null;
            }
        });
        this.putDefault(ActionType.DROP_DOWN, ViewTarget.MENU, new ViewGenerator<DropDownAction, MenuViewItem<JComponent>>(){

            @Override
            public MenuViewItem<JComponent> create(ActionViewConverter actionViewConverter, DropDownAction dropDownAction, Dockable dockable) {
                return new DropDownMenuHandler(dropDownAction, dockable);
            }
        });
        this.putDefault(ActionType.BUTTON, ViewTarget.TITLE, new ViewGenerator<ButtonDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, ButtonDockAction buttonDockAction, Dockable dockable) {
                BasicButtonHandler basicButtonHandler = new BasicButtonHandler(buttonDockAction, dockable);
                BasicMiniButton basicMiniButton = new BasicMiniButton(basicButtonHandler);
                basicButtonHandler.setModel((BasicButtonModel)basicMiniButton.getModel());
                return basicButtonHandler;
            }
        });
        this.putDefault(ActionType.CHECK, ViewTarget.TITLE, new ViewGenerator<SelectableDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, SelectableDockAction selectableDockAction, Dockable dockable) {
                BasicSelectableHandler.Check check = new BasicSelectableHandler.Check(selectableDockAction, dockable);
                BasicMiniButton basicMiniButton = new BasicMiniButton(check);
                check.setModel((BasicButtonModel)basicMiniButton.getModel());
                return check;
            }
        });
        this.putDefault(ActionType.MENU, ViewTarget.TITLE, new ViewGenerator<MenuDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, MenuDockAction menuDockAction, Dockable dockable) {
                BasicMenuHandler basicMenuHandler = new BasicMenuHandler(menuDockAction, dockable);
                BasicMiniButton basicMiniButton = new BasicMiniButton(basicMenuHandler);
                basicMenuHandler.setModel((BasicButtonModel)basicMiniButton.getModel());
                return basicMenuHandler;
            }
        });
        this.putDefault(ActionType.RADIO, ViewTarget.TITLE, new ViewGenerator<SelectableDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, SelectableDockAction selectableDockAction, Dockable dockable) {
                BasicSelectableHandler.Radio radio = new BasicSelectableHandler.Radio(selectableDockAction, dockable);
                BasicMiniButton basicMiniButton = new BasicMiniButton(radio);
                radio.setModel((BasicButtonModel)basicMiniButton.getModel());
                return radio;
            }
        });
        this.putDefault(ActionType.SEPARATOR, ViewTarget.TITLE, new ViewGenerator<SeparatorAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, SeparatorAction separatorAction, Dockable dockable) {
                if (separatorAction.shouldDisplay(ViewTarget.TITLE)) {
                    return new BasicSeparatorHandler(new JSeparator(), separatorAction);
                }
                return null;
            }
        });
        this.putDefault(ActionType.DROP_DOWN, ViewTarget.TITLE, new ViewGenerator<DropDownAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, DropDownAction dropDownAction, Dockable dockable) {
                BasicDropDownButtonHandler basicDropDownButtonHandler = new BasicDropDownButtonHandler(dropDownAction, dockable);
                DropDownMiniButton dropDownMiniButton = new DropDownMiniButton(basicDropDownButtonHandler);
                basicDropDownButtonHandler.setModel((BasicDropDownButtonModel)dropDownMiniButton.getModel());
                return basicDropDownButtonHandler;
            }
        });
        this.putDefault(ActionType.BUTTON, ViewTarget.DROP_DOWN, new ViewGenerator<ButtonDockAction, DropDownViewItem>(){

            @Override
            public DropDownViewItem create(ActionViewConverter actionViewConverter, ButtonDockAction buttonDockAction, Dockable dockable) {
                return new ButtonDropDownHandler(buttonDockAction, dockable, new JMenuItem());
            }
        });
        this.putDefault(ActionType.CHECK, ViewTarget.DROP_DOWN, new ViewGenerator<SelectableDockAction, DropDownViewItem>(){

            @Override
            public DropDownViewItem create(ActionViewConverter actionViewConverter, SelectableDockAction selectableDockAction, Dockable dockable) {
                return new SelectableDropDownHandler(selectableDockAction, dockable, (JMenuItem)new JCheckBoxMenuItem());
            }
        });
        this.putDefault(ActionType.RADIO, ViewTarget.DROP_DOWN, new ViewGenerator<SelectableDockAction, DropDownViewItem>(){

            @Override
            public DropDownViewItem create(ActionViewConverter actionViewConverter, SelectableDockAction selectableDockAction, Dockable dockable) {
                return new SelectableDropDownHandler(selectableDockAction, dockable, (JMenuItem)new JRadioButtonMenuItem());
            }
        });
        this.putDefault(ActionType.SEPARATOR, ViewTarget.DROP_DOWN, new ViewGenerator<SeparatorAction, DropDownViewItem>(){

            @Override
            public DropDownViewItem create(ActionViewConverter actionViewConverter, SeparatorAction separatorAction, Dockable dockable) {
                if (separatorAction.shouldDisplay(ViewTarget.DROP_DOWN)) {
                    return new SubDropDownHandler(new BasicSeparatorHandler(new JPopupMenu.Separator(), separatorAction));
                }
                return null;
            }
        });
        this.putDefault(ActionType.DROP_DOWN, ViewTarget.DROP_DOWN, new ViewGenerator<DropDownAction, DropDownViewItem>(){

            @Override
            public DropDownViewItem create(ActionViewConverter actionViewConverter, DropDownAction dropDownAction, Dockable dockable) {
                return new SubDropDownHandler(dropDownAction.createView(ViewTarget.MENU, actionViewConverter, dockable));
            }
        });
        this.putDefault(ActionType.MENU, ViewTarget.DROP_DOWN, new ViewGenerator<MenuDockAction, DropDownViewItem>(){

            @Override
            public DropDownViewItem create(ActionViewConverter actionViewConverter, MenuDockAction menuDockAction, Dockable dockable) {
                return new SubDropDownHandler(menuDockAction.createView(ViewTarget.MENU, actionViewConverter, dockable));
            }
        });
    }

    public <A, D extends DockAction> void putClient(ActionType<D> actionType, ViewTarget<A> viewTarget, ViewGenerator<D, A> viewGenerator) {
        if (actionType == null) {
            throw new IllegalArgumentException("Action must not be null");
        }
        if (viewTarget == null) {
            throw new IllegalArgumentException("Target must not be null");
        }
        Entry<D, A> entry = this.getEntry(actionType, viewTarget);
        entry.clientGenerator = viewGenerator;
    }

    public <A, D extends DockAction> void putTheme(ActionType<D> actionType, ViewTarget<A> viewTarget, ViewGenerator<D, A> viewGenerator) {
        if (actionType == null) {
            throw new IllegalArgumentException("Action must not be null");
        }
        if (viewTarget == null) {
            throw new IllegalArgumentException("Target must not be null");
        }
        Entry<D, A> entry = this.getEntry(actionType, viewTarget);
        entry.themeGenerator = viewGenerator;
    }

    public <A, D extends DockAction> void putDefault(ActionType<D> actionType, ViewTarget<A> viewTarget, ViewGenerator<D, A> viewGenerator) {
        if (actionType == null) {
            throw new IllegalArgumentException("Action must not be null");
        }
        if (viewTarget == null) {
            throw new IllegalArgumentException("Target must not be null");
        }
        Entry<D, A> entry = this.getEntry(actionType, viewTarget);
        entry.defaultGenerator = viewGenerator;
    }

    public <A> A createView(DockAction dockAction, ViewTarget<A> viewTarget, Dockable dockable) {
        return dockAction.createView(viewTarget, this, dockable);
    }

    public <A, D extends DockAction> A createView(ActionType<D> actionType, D d, ViewTarget<A> viewTarget, Dockable dockable) {
        ViewGenerator<D, A> viewGenerator = this.getConverter(actionType, viewTarget);
        if (viewGenerator == null) {
            throw new IllegalArgumentException("That combination is not known: " + actionType + " " + viewTarget);
        }
        return viewGenerator.create(this, d, dockable);
    }

    protected <A, D extends DockAction> ViewGenerator<D, A> getConverter(ActionType<D> actionType, ViewTarget<? super A> viewTarget) {
        Entry<D, ? super A> entry = this.getEntry(actionType, viewTarget);
        if (entry.clientGenerator != null) {
            return entry.clientGenerator;
        }
        if (entry.themeGenerator != null) {
            return entry.themeGenerator;
        }
        return entry.defaultGenerator;
    }

    private <A, D extends DockAction> Entry<D, A> getEntry(ActionType<D> actionType, ViewTarget<? super A> viewTarget) {
        Entry<Object, Object> entry = this.converters.get(new Tuple<ActionType<D>, ViewTarget<? super A>>(actionType, viewTarget));
        if (entry == null) {
            entry = new Entry();
            this.converters.put(new Tuple<ActionType<D>, ViewTarget<? super A>>(actionType, viewTarget), entry);
        }
        return entry;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<D extends DockAction, A> {
        public ViewGenerator<D, A> clientGenerator;
        public ViewGenerator<D, A> themeGenerator;
        public ViewGenerator<D, A> defaultGenerator;

        private Entry() {
        }
    }
}

